from paysys.sre.tools.monitorings.lib.checks import base
from paysys.sre.tools.monitorings.lib.util.helpers import check, gen_children, merge, gen_unreach_by_service, flaps, ttl, unreach_skip
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_or, logic_and, downtime_skip

host = "oebs.stable.target"  # VIRT HOST
children = ['oebs_prod_storage']  # CGROUP


def checks():
    result = merge(
        base.common_fin_fin(children),
        check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                              logic_or, unreach_skip, downtime_skip)),
        check('apps_web-forms', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'apps_web-forms'),
                                      logic_and, unreach_skip, downtime_skip)),
        check('apps_java-forms', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'apps_java-forms'),
                                       logic_and, unreach_skip, downtime_skip)),
        check('rdbms_oebs-st', merge(flaps(100, 300), ttl(630, 330), gen_children(children, 'rdbms_oebs-st'),
                                       logic_and, unreach_skip, downtime_skip)),
        check('unispace5', merge(flaps(300, 900), ttl(620, 300), gen_children(children, 'unispace5'),
                                   logic_or, unreach_skip, downtime_skip)),
    )

    # Warden tags
    result['apps_web-forms']['tags'] = [
        'warden_functionality_oebs_apps_web-forms',
        'warden_auto_source',
        'warden_alert_create_spi'
    ]
    result['apps_java-forms']['tags'] = [
        'warden_functionality_oebs_apps_java-forms',
        'warden_auto_source',
        'warden_alert_create_spi'
    ]
    result['rdbms_oebs-st']['tags'] = [
        'warden_functionality_oebs_rdbms_oebs-st',
        'warden_auto_source',
        'warden_alert_create_spi'
    ]

    result = gen_unreach_by_service(result)
    return result
