from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, flaps, gen_children
from paysys.sre.tools.monitorings.lib.checks.active.http import https
from paysys.sre.tools.monitorings.lib.checks.doc import doc_link


def get_checks(children):
    appl = {
        'check-certs': merge(ttl(3700, 90), doc_link('wto.oebs.yandex-team.ru')),
        'jdbc-pool': merge(flaps(900, 0), ttl(620, 300), doc_link('wto.oebs.yandex-team.ru')),
        'tomcat-alive': merge(ttl(620, 300), doc_link('wto.oebs.yandex-team.ru')),
        'tvm_health': merge(ttl(600, 300), gen_children(children, ['tvm_ping'])),
    }

    return merge(appl, https(name='ping-wto', path='/mobilka/webapi/admin/ping'),
                 https(name='ping-oebsapi', path='/oebsapi/admin/rest/ping'))
