from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, check, unreach_force_ok, gen_unreach_by_service, \
    unreach_skip, nodata_skip, flaps, gen_children
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_or, logic_and, downtime_force_ok, downtime_skip
from paysys.sre.tools.monitorings.lib.checks.base import unreachable

host = "oebs.function"  # VIRT HOST
children = ["oebs_prod_db"]  # CGROUP

unreach = unreachable.copy()
unreach["UNREACHABLE"].update(logic_or)


def checks():
    result = merge(
        check("a-timeouted-conc_automat", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-billing-int-verify_diffs", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(4000, 3600), logic_or),
        check("f-programs-billing-int-delay", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(4000, 3600), logic_or),
        check("f-disabled-xx-pay_trig_events", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(360, 300), logic_or),
        check("f-duplicated-pqh_roles", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-duplicated-summary_accounts", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(360, 300), logic_or),
        check("f-duplicate-billing_akts", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(360, 300), logic_or),
        check("f-enddate_records_wf_relation", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(87500, 1800), logic_or),
        check("f-error-fisc_check", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-error-fnd_flex_hierarchies", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-error-fnd_svc_components", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-error-phase_conc", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-error-programs", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(700, 350), logic_or),
        check("f-error-programs-taxi", merge(unreach_force_ok, downtime_force_ok, nodata_skip, {'tags': ['warden_alert_create_spi']}), ttl(700, 350), logic_or),
        check("f-error-xxya_log_messages", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-fnd_lookup_values", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(360, 300), logic_or),
        check("f-full-concurrent_queue", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(4000, 3600), logic_or),
        check("f-inactive-cost_manager", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(4000, 3600), logic_or),
        # check("f-interfaces", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(2600000, 2595000), logic_or),
        check("f-invalid-xx-all_objects", merge(flaps(0, 1800), unreach_force_ok, downtime_force_ok, nodata_skip), ttl(360, 300), logic_or),
        check("f-invalid-xx-triggers", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(4000, 3600), logic_or),
        check("f-large-output_programs", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-long-running-programs", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-long-running-programs-taxi", merge(unreach_force_ok, downtime_force_ok, nodata_skip, {'tags': ['warden_alert_create_spi']}), logic_or),
        check("f-long-running-system", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-meta-endocs", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-non-comp-xx_xla_prd_rul", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(4000, 3600), logic_or),
        check("f-profile-values", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-send-error-fisc_check", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-sla_gl_final_mode", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(87500, 1800), logic_or),
        check("f-timeouted-conc_automat", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-timeouted-conc_automat-taxi", merge(unreach_force_ok, downtime_force_ok, nodata_skip, {'tags': ['warden_alert_create_spi']}), logic_or),
        check("f-wf-out-errors", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-workflow-mail", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-ws-ping", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-long-concurrent", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(4000, 3700), logic_or),
        check("f-error-programs-billing-int", merge(unreach_force_ok, downtime_force_ok, nodata_skip), ttl(360, 300), logic_or),
        # OEBSADMIN-26424
        check("fk-indexing", merge(flaps(300, 900), ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
        check("matview-monitor", merge(flaps(300, 900), ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
        check("matview-refresh", merge(flaps(300, 900), ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
        check('mviewlog-usage', merge(flaps(300, 900), ttl(3700, 1800), logic_and, unreach_skip, downtime_skip)),
        check("seq-check", merge(flaps(300, 900), ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
        check("database-up", merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'), logic_or, unreach_skip, downtime_skip)),
        check("grid-up", merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'), logic_or, unreach_skip, downtime_skip)),
        check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'), logic_or, unreach_skip, downtime_skip)),
        check("f-timeouted-conc_automat-market", merge(unreach_force_ok, downtime_force_ok, nodata_skip, {'tags': ['warden_alert_create_spi']}), logic_or),
        check("f-long-running-programs-market", merge(unreach_force_ok, downtime_force_ok, nodata_skip, {'tags': ['warden_alert_create_spi']}), logic_or),
        check("f-error-programs-market", merge(unreach_force_ok, downtime_force_ok, nodata_skip, {'tags': ['warden_alert_create_spi']}), logic_or),
        check("f-timeouted-conc_automat-cpa", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-long-running-programs-cpa", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        check("f-error-programs-cpa", merge(unreach_force_ok, downtime_force_ok, nodata_skip), logic_or),
        unreach
    )
    result = gen_unreach_by_service(result)
    return result
