import paysys.sre.tools.monitorings.configs.oplata.base.oplata as oplata
from paysys.sre.tools.monitorings.lib.notifications import Notifications

notifications = Notifications()
notifications.set_telegram(group=[
    '@svc_billing_swat_team:main',
    '@svc_billing_swat_team:reserve',
], delay=60)
notifications.set_iron_woman(logins=[
    '@svc_billing_swat_team:main',
    '@svc_billing_swat_team:reserve',
    'bremk',
    'ozhegov',
    'dskut'
], delay=300)

defaults = {'namespace': 'oplata.stable'}
host = "oplata.stable"

children = {}
for du in ['admin', 'documents', 'payments', 'sdk', 'workers-moderation', 'workers-payments']:
    children[du] = 'oplata@stage=oplata-prod-stage;deploy_unit=%s' % du

l7_balancer = [
    {
        "namespace": "oplata.billing.yandex.net",
        "datacenters": ["man", "sas", "vla"],
        "host": "oplata.billing.yandex.net",
        "http_ports": [80],
        "https_ports": [443],
        "services": [
            "rtc_balancer_oplata_billing_yandex_net_man",
            "rtc_balancer_oplata_billing_yandex_net_sas",
            "rtc_balancer_oplata_billing_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 1, "crit": 3}
        },
    }
]


def checks():
    return oplata.get_checks(children, l7_balancer, 'prod')
