from paysys.sre.tools.monitorings.lib.checks.base import common
from paysys.sre.tools.monitorings.lib.checks.doc import doc
from paysys.sre.tools.monitorings.lib.util.helpers import merge, flaps, ttl
from paysys.sre.tools.monitorings.lib.notifications import Notifications, FIN_TOOLS_TELEGRAM_GROUP


TELEGRAM_GROUP = ["yndx-mnt-fin-payment_monitoring"]
CALENDAR_ID = 27382
IRON_WOMAN_DELAY = 1200
ESCALATION_USERS = [
    "@svc_paysys-admin:ops",
    "allazarev",
    "iandreyev",
]

ABC_DUTY = [
    "@svc_paysys-admin:ops",
]

notifications_object = Notifications()
notifications_object.set_telegram(TELEGRAM_GROUP)
notifications_object.set_abc_duty(ABC_DUTY)
notifications_object.set_iron_woman(logins=ESCALATION_USERS, delay=IRON_WOMAN_DELAY)


fin_tools_notifications_object = Notifications()
fin_tools_notifications_object.set_telegram(TELEGRAM_GROUP + FIN_TOOLS_TELEGRAM_GROUP)
fin_tools_notifications_object.set_abc_duty(ABC_DUTY)
fin_tools_notifications_object.set_iron_woman(logins=ESCALATION_USERS, delay=IRON_WOMAN_DELAY)
fin_tools_notifications = fin_tools_notifications_object.iron_woman_and_sms_abc_and_telegram
fin_tools_notifications_telegram = fin_tools_notifications_object.telegram


def checks_common(children):
    return merge(
        common(children),
        {
            "syslog-alive": doc("https://wiki.yandex-team.ru/dljaadminov/paysys/ps/syslog-ng/"),
            "push-client": merge(flaps(900, 3600), ttl(3780, 300)),
        },
    )
