import paysys.sre.tools.monitorings.lib.checks.mongo as mongo
import paysys.sre.tools.monitorings.lib.checks.services as services
from paysys.sre.tools.monitorings.configs.paysys.base import checks_common
from paysys.sre.tools.monitorings.lib.util.helpers import merge, flaps, ttl


def get_checks(children, cluster, shards):
    exclude_checks = [
        'push-client'
    ]
    checks = merge(
        checks_common(children),
        services.keepalived,
        mongo.backup(children),
        mongo.mongo_with_single_shardgroup(children, cluster, shards)
    )

    # There is no need to maintain stable rs lag on backup servers.
    # Just check that lag is was 0 at least one time in 24 hours and no
    # NO DATA for last 2 hours
    checks = merge(
        checks,
        {'mongo_rs_lag': flaps(600, 86000)},
        {'mongo_rs_lag': ttl(7200, 60)},
        {'mongo_rs_state': ttl(7200, 60)},
        {'mongo_connect': ttl(7200, 60)},
    )

    for exclude_check in exclude_checks:
        checks.pop(exclude_check)
    return checks
