from paysys.sre.tools.monitorings.lib.checks.active.http import http

from paysys.sre.tools.monitorings.configs.mdh.common import ProjectConfig, Component, CheckRule


class RefsConfig(ProjectConfig):

    project = 'refs'

    components = [
        Component(
            alias='backend',
            port=8080,
            fqdn='{prj[-env]}.{dom_paysys}',
            balancer_service='rtc_balancer_{prj[-env]}-l7_paysys_yandex_net',
            location=['iva', 'myt', 'sas'],
        )
    ]

    check_haproxy = False

    def get_check_rules(self, pg_cluster=''):

        rules = super(RefsConfig, self).get_check_rules(
            pg_cluster=pg_cluster,
        )

        backend = self.get_component('backend')

        rules.append(CheckRule(
            # Ходим на поды, а там только http
            http(
                'cbrf-listing',
                path='/api/cbrf?query=%7Blisting%20%7BnameFull%20zip%7D%7D',
                headers={'Host': backend.fqdn},
                crit='10%',
                warn='10%',
                ok_codes=[200],
                port=backend.port,
            ),
            per_child=True
        ))

        return rules
