from paysys.sre.tools.monitorings.lib.checks import base
from paysys.sre.tools.monitorings.configs.reports.base import apps
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and
from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, flaps
from paysys.sre.tools.monitorings.lib.checks.active.http import https, https_cert
from paysys.sre.tools.monitorings.lib.checks import services

host = "reports.stable.apps"  # VIRT HOST
children = ['balance_reports']  # CGROUP


def checks():
    crt_answer = https('crt_answers.yandex-team.ru', path='/check', warn='30%', crit='50%')
    crt_apex = https_cert('crt_apex.balance.yandex.ru', port=4443)
    ping_apex = https('http-ping-apex', port=4443, path='/check', headers={'Host': 'apex.balance.yandex.ru'})

    crt_answer['crt_answers.yandex-team.ru'].update(merge(ttl(900, 90), flaps(200, 1200), logic_and))
    crt_answer['crt_answers.yandex-team.ru']['active_kwargs'].update({'warn_expire': 21,
                                                                      'crit_expire': 10,
                                                                      'fail_logic': 'every'})

    crt_apex['crt_apex.balance.yandex.ru'].update(merge(ttl(900, 90), flaps(200, 1200)))
    ping_apex['http-ping-apex'].update(merge(ttl(900, 60), flaps(180, 600)))

    crt_answer['crt_answers.yandex-team.ru']['aggregator'] = 'logic_and'
    crt_answer['crt_answers.yandex-team.ru']['aggregator_kwargs'].pop('limits')
    crt_answer['crt_answers.yandex-team.ru']['aggregator_kwargs']['unreach_mode'] = 'force_ok'
    crt_apex['crt_apex.balance.yandex.ru']['aggregator_kwargs']['unreach_mode'] = 'force_ok'
    ping_apex['http-ping-apex']['aggregator_kwargs']['unreach_mode'] = 'force_ok'

    return merge(base.common_fin_fin(children), services.haproxy, apps.get_checks(children), crt_apex, crt_answer, ping_apex)
