from paysys.sre.tools.monitorings.lib.checks.base import common
from paysys.sre.tools.monitorings.lib.notifications import Notifications
from paysys.sre.tools.monitorings.lib.checks.doc import doc
from paysys.sre.tools.monitorings.lib.util.helpers import merge, flaps, ttl


TELEGRAM_GROUP = [
    "trust_telegram",
    "yndx-mnt-fin-payment_monitoring",
]
CALENDAR_ID = 27382
IRON_WOMAN_DELAY = 1200
IRON_WOMAN_IMPORTANT_DELAY = 30
ESCALATION_USERS = [
    "@svc_strust:trust_dev_duty",
    "@svc_paysys-admin:ops",
    "sunshineguy",
    "selivanov",
]

ABC_DUTY = [
    "@svc_strust:trust_dev_duty",
    "@svc_paysys-admin:ops",
]

SENTRY_TELEGRAM_GROUP = ["trust_telegram"]

TELEGRAM_NOTIFICATION_STATUSES = [
    "CRIT",
    {"from": "CRIT", "to": "OK"},
    {"from": "CRIT", "to": "WARN"},
]

notifications_object = Notifications()
notifications_object.set_telegram(TELEGRAM_GROUP, None, TELEGRAM_NOTIFICATION_STATUSES)
notifications_object.set_calendar(CALENDAR_ID)
notifications_object.set_abc_duty(ABC_DUTY)
notifications_object.set_iron_woman(ESCALATION_USERS, IRON_WOMAN_DELAY)

sentry_notifications_object = Notifications()
sentry_notifications_object.set_telegram(SENTRY_TELEGRAM_GROUP)
sentry_notifications_object.set_startrek(
    queue="TRUSTDUTY",
    components=["func:infrastructure"],
    priority="critical",
)

important_notification_object = Notifications()
important_notification_object.set_telegram(
    TELEGRAM_GROUP, None, TELEGRAM_NOTIFICATION_STATUSES
)
important_notification_object.set_iron_woman(
    ESCALATION_USERS, IRON_WOMAN_IMPORTANT_DELAY
)
important_notification_object.set_abc_duty(ABC_DUTY)


def checks_common(children):
    return merge(
        common(children),
        {
            "syslog-alive": doc(
                "https://wiki.yandex-team.ru/dljaadminov/paysys/ps/syslog-ng/"
            ),
            "push-client": merge(flaps(900, 3600), ttl(3780, 300)),
        },
    )
