import juggler_sdk

from paysys.sre.tools.monitorings.lib.util import yasm_template
from paysys.sre.tools.monitorings.lib.util.helpers import merge


def total_limited(host, name):
    yasm_alert_name = "{}.{}-total_limited".format(yasm_template.get_key(host), name)
    check_name = "{}-total_limited".format(name)
    dashboard_url = "https://yasm.yandex-team.ru/template/panel/trust-rpslimiter-dashboard/name={}/".format(
        name
    )
    alert_url = "https://yasm.yandex-team.ru/alert/{}".format(yasm_alert_name)
    return {
        check_name: {
            "aggregator_kwargs": {
                "unreach_service": [{"check": "yasm_alert:virtual-meta"}],
                "nodata_mode": "force_ok",
                "unreach_mode": "force_ok",
            },
            "children": [
                juggler_sdk.Child("yasm_alert", yasm_alert_name, group_type="HOST")
            ],
            "flaps_config": juggler_sdk.FlapOptions(60, 300),
            "meta": {
                "yasm_alert_name": yasm_alert_name,
                "urls": [
                    {
                        "type": "wiki",
                        "title": "Dashboard",
                        "url": dashboard_url,
                    },
                    {
                        "type": "yasm_alert",
                        "title": "Yasm alert",
                        "url": alert_url,
                    },
                ],
            },
        }
    }


def get_checks(host, names):
    checks = [total_limited(host, name) for name in names]
    return merge(*checks)


def get_yasm_template(host, thresholds):
    rpslimiter_thresholds = []
    for name in sorted(thresholds.keys()):
        t = thresholds[name]
        rpslimiter_thresholds.append(
            "('{name}', {warn}, {crit})".format(name=name, warn=t.warn, crit=t.crit)
        )

    alert_content = (
        "[\n"
        "<% for name, warn, crit in [{rpslimiter_thresholds}] %>\n"
        "    <% set re_quotas = 'unistat-quotas-' ~ name ~ '-(?P<quota>[a-z0-9\\-]+)-Limited_summ' %>\n"
        "     <% set signals = list_signals(pattern=re_quotas, itype='rpslimiter', ctype='prod', hosts='ASEARCH')|join(',') %>\n"
        "     {{\n"
        "        'name': '<< name ~ \"-total_limited\" >>',\n"
        "        'signal': '<< \"sum(\" ~ signals ~ \")\" >>',\n"
        "        'tags': {{'itype': 'rpslimiter', 'ctype': 'prod', 'prj': 'main'}},\n"
        "        'mgroups': ['ASEARCH'],\n"
        "        'abc': 'strust',\n"
        "        'warn': [<<warn>>, <<crit>>],\n"
        "        'crit': [<<crit>>, None],\n"
        "    }},\n"
        "<% endfor %>\n"
        "]\n"
    ).format(rpslimiter_thresholds=",".join(rpslimiter_thresholds))

    return {
        "content": alert_content,
        "owners": ["afrolovskiy", "selivanov"],
        "abc": "strust",
        "is_periodic": True,
    }
