from paysys.sre.tools.monitorings.lib.checks.active.http import http
from paysys.sre.tools.monitorings.lib.checks.awacs import l7_monitoring
from paysys.sre.tools.monitorings.lib.checks.base import unreachable
from paysys.sre.tools.monitorings.lib.util.helpers import merge, check, gen_children_deploy


def l7_balancer(fqdn, dcs):
    return [
        {
            "namespace": fqdn,
            "datacenters": dcs,
            "host": fqdn,
            "http_ports": [80],
            "https_ports": [443],
            "services": ['rtc_balancer_{0}_{1}'.format(fqdn.replace('.', '_'), dc) for dc in dcs],
            "checks": {
                "cpu_usage": {"warn": 60, "crit": 80},
                "cpu_wait": {"warn": 0.5, "crit": 1},
                "codes_5xx": {"warn": 0.5, "crit": 1},
                "attempts_backend_errors": {"warn": 1, "crit": 2},
            },
        },
    ]


def get_checks(children, balancers):
    return merge(
        l7_monitoring(balancers),
        unreachable,
        http('ping-timeline', path='/ping-timeline', port=80, ok_codes=[200, 301, 302], crit=0, headers={"Host": "localhost"}),
        http('ping-api', path='/ping-api', port=80, ok_codes=[200, 301, 302], crit=0, headers={"Host": "localhost"}),
        http('ping-tms', path='/ping-tms', port=80, ok_codes=[200, 301, 302], crit=0, headers={"Host": "localhost"}),
        check('ping-timeline', gen_children_deploy(children, 'ping-timeline')),
        check('ping-tms', gen_children_deploy(children, 'ping-tms')),
        check('ping-api', gen_children_deploy(children, 'ping-api')),
        *[
            check(x, gen_children_deploy(children, x))
            for x in [
                'UNREACHABLE'
            ]
        ]
    )
