from paysys.sre.tools.monitorings.lib.checks.active.http import http
from paysys.sre.tools.monitorings.lib.checks.awacs import l7_monitoring
from paysys.sre.tools.monitorings.lib.checks.base import unreachable
from paysys.sre.tools.monitorings.lib.util.helpers import merge, check, gen_children_deploy


def get_checks(children, balancers):
    return merge(
        l7_monitoring(balancers),
        unreachable,
        http('api', 8080, ok_codes=[200, 301, 302], crit=0, headers={"Host": "localhost"}),
        check('api', gen_children_deploy(children, 'api')),
        *[
            check(x, gen_children_deploy(children, x))
            for x in [
                'UNREACHABLE'
            ]
        ]
    )
