from collections import namedtuple

import solomon_client


thresholds = namedtuple("thresholds", ["warn", "crit"])


# Channel for notifications from solomon to juggler.
# Target host and services are specified via juggler_host and juggler_service annotations in Solomon alert.
# https://solomon.yandex-team.ru/admin/projects/trust/channels/juggler_event
juggler_event_channel = solomon_client.AssociatedChannel(
    id="juggler_event",
    config=solomon_client.ChannelConfig(
        notify_about_statuses=["ALARM", "WARN", "OK", "ERROR"],
        repeat_delay_secs=0,
    ),
)
