from paysys.sre.tools.monitorings.lib.checks.awacs import l7_monitoring
from paysys.sre.tools.monitorings.lib.util.helpers import empty_children

host = "trust.dev.l7"

children = empty_children

l7_balancers = [
    {
        "namespace": "trust-emulator-dev-l7.paysys.yandex.net",
        "datacenters": ["sas", "vla"],
        "host": "trust-emulator-dev.paysys.yandex.net",
        "http_ports": [],
        "https_ports": [8303],
        "services": [
            "rtc_balancer_trust-emulator-dev-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-emulator-dev-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 0.5, "crit": 1},
            "attempts_backend_errors": {"warn": 1, "crit": 2},
        },
    },
    {
        "namespace": "trust-dev-l7.paysys.yandex.net",
        "datacenters": ["sas", "vla"],
        "host": "trust-dev.paysys.yandex.net",
        "http_ports": [],
        "https_ports": [443],
        "services": [
            "rtc_balancer_trust-dev-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-dev-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 0.5, "crit": 1},
            "attempts_backend_errors": {"warn": 1, "crit": 2},
        },
    },
    {
        "namespace": "trust-payments-dev-l7.paysys.yandex.net",
        "datacenters": ["sas", "vla"],
        "host": "trust-payments-dev.paysys.yandex.net",
        "http_ports": [],
        "https_ports": [8028],
        "services": [
            "rtc_balancer_trust-payments-dev-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-payments-dev-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 0.5, "crit": 1},
            "attempts_backend_errors": {"warn": 1, "crit": 2},
        },
    },
    {
        "namespace": "trust-payments-old-dev-l7.paysys.yandex.net",
        "datacenters": ["sas", "vla"],
        "host": "trust-payments-old-dev.paysys.yandex.net",
        "http_ports": [],
        "https_ports": [8027],
        "services": [
            "rtc_balancer_trust-payments-old-dev-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-payments-old-dev-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 0.5, "crit": 1},
            "attempts_backend_errors": {"warn": 1, "crit": 2},
        },
    },
    {
        "namespace": "trust-payments-xg-dev-l7.paysys.yandex.net",
        "datacenters": ["sas", "vla"],
        "host": "trust-payments-xg-dev.paysys.yandex.net",
        "http_ports": [],
        "https_ports": [8038],
        "services": [
            "rtc_balancer_trust-payments-xg-dev-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-payments-xg-dev-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 0.5, "crit": 1},
            "attempts_backend_errors": {"warn": 1, "crit": 2},
        },
    },
    {
        "namespace": "trust-paysys-dev-l7.paysys.yandex.net",
        "datacenters": ["sas", "vla"],
        "host": "trust-paysys-dev.paysys.yandex.net",
        "http_ports": [],
        "https_ports": [8025],
        "services": [
            "rtc_balancer_trust-paysys-dev-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-paysys-dev-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 0.5, "crit": 1},
            "attempts_backend_errors": {"warn": 1, "crit": 2},
        },
    },
    {
        "namespace": "trust-lpm-dev-l7.paysys.yandex.net",
        "datacenters": ["sas", "vla"],
        "host": "trust-lpm-dev.paysys.yandex.net",
        "http_ports": [],
        "https_ports": [8031],
        "services": [
            "rtc_balancer_trust-lpm-dev-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-lpm-dev-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 0.5, "crit": 1},
            "attempts_backend_errors": {"warn": 1, "crit": 2},
        },
    },
    {
        "namespace": "trust-directory-dev-l7.paysys.yandex.net",
        "datacenters": ["sas", "vla"],
        "host": "trust-directory-dev.paysys.yandex.net",
        "http_ports": [],
        "https_ports": [443],
        "services": [
            "rtc_balancer_trust-directory-dev-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-directory-dev-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 0.5, "crit": 1},
            "attempts_backend_errors": {"warn": 1, "crit": 2},
        },
    },
    {
        "namespace": "trust-assistant-dev-l7.paysys.yandex.net",
        "datacenters": ["sas", "vla"],
        "host": "assistant.trust.dev.yandex.net",
        "http_ports": [],
        "https_ports": [443],
        "services": [
            "rtc_balancer_trust-assistant-dev-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-assistant-dev-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 0.5, "crit": 1},
            "attempts_backend_errors": {"warn": 1, "crit": 2},
        },
    },
    {
        "namespace": "callback.trust.dev.yandex.net",
        "datacenters": ["sas", "vla"],
        "host": "callback.trust.dev.yandex.net",
        "http_ports": [],
        "https_ports": [443],
        "services": [
            "rtc_balancer_callback_trust_dev_yandex_net_sas",
            "rtc_balancer_callback_trust_dev_yandex_net_vla"
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 0.5, "crit": 1},
            "attempts_backend_errors": {"warn": 1, "crit": 2},
        },
    },
]


def checks():
    return l7_monitoring(l7_balancers)
