from paysys.sre.tools.monitorings.lib.checks.postgres import postgres
from paysys.sre.tools.monitorings.lib.util.helpers import merge

host = "trust.dev.postgres"

children = []

tags = ["trust_postgres"]


def checks():
    return merge(
        postgres(
            cluster_id="8390294f-ef6d-4242-83bb-b382b8790014",
            db_name="trust_payments_development",
            users=[
                "trust_directory_app",
                "trust_export_ng_app",
                "trust_export_xg_app",
                "trust_gateway",
                "trust_notify_ng_app",
                "trust_notify_xg_app",
                "trust_payments_app",
                "trust_payments_xg_app",
                "trust_worker_ng_app",
                "trust_worker_app",
            ],
            tags=tags
        ),
        postgres(
            cluster_name="trust_gomer_dev",
            cluster_id="mdbovdefh81b3c8uivgv",
            db_name="trust_gomer_dev",
            conn_limit=100,
            tags=tags
        ),
        postgres(
            cluster_id="mdbpq12vmv7hto2u1fvj",
            db_name="trust_emulator_dev",
            tags=tags
        ),
        postgres(
            cluster_id="mdb2b65q9fct1hd0ii50",
            db_name="trust_receipts_dev",
            tags=tags
        ),
        postgres(
            cluster_id="mdb568tqgdiv5p67qvl7",
            db_name="trust_scheduler_dev",
            tags=tags
        ),
        postgres(
            cluster_name="trust_metadata_dev",
            cluster_id="mdb49r8jv5m5mh75m9bn",
            db_name="trust_metadata_dev",
            conn_limit=100,
            tags=tags
        ),
        postgres(
            cluster_name="trust_utility_dev",
            cluster_id="mdbrhuqh6d7c9guj07bn",
            db_name="trust_utility_dev",
            conn_limit=100,
            disk_space_warn_threshold=60,
            disk_space_crit_threshold=80,
            tags=tags,
        ),
    )
