from paysys.sre.tools.monitorings.lib.checks.postgres import postgres
from paysys.sre.tools.monitorings.lib.util.helpers import merge

host = "trust.load.postgres"

children = []

tags = ["trust_postgres"]


def checks():
    return merge(
        postgres(
            cluster_id="acf14e0d-13ef-4eb2-a7b8-0ee52732aae5",
            db_name="trust_payments_load",
            users=[
                "trust_directory_app",
                "trust_export_ng_app",
                "trust_export_xg_app",
                "trust_gateway",
                "trust_notify_ng_app",
                "trust_notify_xg_app",
                "trust_payments_app",
                "trust_payments_xg_app",
                "trust_worker_ng_app",
                "trust_worker_app",
            ],
            tags=tags
        ),
        postgres(
            cluster_name="trust_gomer_load",
            cluster_id="mdbmctl9f8gm56iujev4",
            db_name="trust_gomer_load",
            conn_limit=100,
            tags=tags
        ),
        postgres(
            cluster_name="trust_metadata_load",
            cluster_id="mdbpi4sp83qi8na8gavc",
            db_name="trust_metadata_load",
            conn_limit=100,
            tags=tags
        ),
    )
