from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl
from paysys.sre.tools.monitorings.configs.trust.base import (
    important_notification_object,
    notifications_object,
    sentry_notifications_object,
)

defaults = merge(
    ttl(620, 60),
    {"namespace": "trust.stable"},
)

notifications = {
    "default": notifications_object.iron_woman_and_telegram,
    "by_service": {
        # iron_woman_and_sms_abc_and_telegram
        "UNREACHABLE": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "haproxy": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "iptruler": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "link": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "mongo_connect": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "mongo_rs_state": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "mongo_rs_lag": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "nginx-alive": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "oracle-conn": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "ps-ping-alive": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "spinlock_delay": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "yandex-passport-tvmtool": notifications_object.iron_woman_and_sms_abc_and_telegram,
        # iron_woman_and_sms_abc_and_telegram_graphite
        "db-latency": notifications_object.iron_woman_and_sms_abc_and_telegram_graphite,
        "nginx_errors": notifications_object.iron_woman_and_sms_abc_and_telegram_graphite,
        "nginx_499": notifications_object.iron_woman_and_sms_abc_and_telegram_graphite,
        "nginx_499_5min": notifications_object.iron_woman_and_sms_abc_and_telegram_graphite,
        "nginx_499_percent": notifications_object.iron_woman_and_sms_abc_and_telegram_graphite,
        # iron_woman_daytime_and_sms_abc_and_telegram
        "keepalived_conf": notifications_object.iron_woman_daytime_and_sms_abc_and_telegram,
        "push-client": notifications_object.iron_woman_daytime_and_sms_abc_and_telegram,
        "unispace": notifications_object.iron_woman_daytime_and_sms_abc_and_telegram,
        # iron_woman_daytime_and_telegram
        "bmc": notifications_object.iron_woman_daytime_and_telegram,
        "clock": notifications_object.iron_woman_daytime_and_telegram,
        "cpu": notifications_object.iron_woman_daytime_and_telegram,
        "disk": notifications_object.iron_woman_daytime_and_telegram,
        "ecc": notifications_object.iron_woman_daytime_and_telegram,
        "gpu": notifications_object.iron_woman_daytime_and_telegram,
        "mem": notifications_object.iron_woman_daytime_and_telegram,
        "mysql_xtrabackup": notifications_object.iron_woman_daytime_and_telegram,
        "mysqldump": notifications_object.iron_woman_daytime_and_telegram,
        "switch_uplink_flaps": notifications_object.iron_woman_daytime_and_telegram,
        # sms_abc_and_telegram
        "check-certs": notifications_object.sms_abc_and_telegram,
        "paysys_archiver": notifications_object.sms_abc_and_telegram,
        # telegram
        "hwerrors2": notifications_object.telegram,
        "pkgver": notifications_object.telegram,
        "salt-minion": notifications_object.telegram,
        "sox-agent": notifications_object.telegram,
        # noop
        "certs": notifications_object.noop,
        "disk-util": notifications_object.noop,
        "disk-wait": notifications_object.noop,
        "graphite-client": notifications_object.noop,
        "syslog-alive": notifications_object.noop,
        # no notifications
        "mongo_statistics": {},
        "watchdog": {},
    },
    "by_tag": {
        # iron_woman_and_sms_abc_and_telegram
        "https_main": notifications_object.iron_woman_and_sms_abc_and_telegram,
        "trust_postgres": notifications_object.iron_woman_and_sms_abc_and_telegram,
        # sms_abc_and_telegram
        "https_cert": notifications_object.sms_abc_and_telegram,
        # startrek_and_telegram
        "trust_sentry_postgres": sentry_notifications_object.startrek_and_telegram,
    },
    "by_host": {
        # telegram
        "trust.elastic": notifications_object.telegram,
        "trust.fraud-admin.app": notifications_object.telegram,
        "trust.fraud-admin.postgres": notifications_object.telegram,
        "trust.mongo-mdb.payments": {},  # in testing mode
        "trust.rpslimiter": notifications_object.telegram,
        "trust.scrooge": notifications_object.telegram,
        "trust.timeline": notifications_object.telegram,
        "trust.timeline2": notifications_object.telegram,
        "trust.timeline-sox": notifications_object.telegram,
        # iron_woman_daytime_and_sms_abc_and_telegram
        "trust.logreceiver": notifications_object.iron_woman_daytime_and_sms_abc_and_telegram,
        "trust.ark": notifications_object.iron_woman_daytime_and_sms_abc_and_telegram,
        # iron_woman_and_sms_abc_and_telegram
        "trust.scheduler": important_notification_object.iron_woman_and_sms_abc_and_telegram,
        "trust.scheduler.critical": important_notification_object.iron_woman_and_sms_abc_and_telegram,
    },
}

CONFIGS = [
    "ark",
    "elastic",
    "fraud_admin",
    "fraud_admin_postgres",
    "gate",
    "logreceiver",
    "rpslimiter",
    "s3_mds",
    "scheduler",
    "scheduler_critical",
    "scrooge",
    "terminal_selector",
    "timeline",
    "timeline2",
    "timeline_sox",
    "trust",
    "trust_atlas",
    "trust_l7",
    "trust_lpm_deploy",
    "trust_mongo",
    "trust_mongobckp",
    "trust_postgres",
    "trust_uzcard3ds",
    "yt",
]
