from paysys.sre.tools.monitorings.lib.checks.base import common, pkgver, cpu_usage
from paysys.sre.tools.monitorings.lib.checks.graphite import graphite_check
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and
from paysys.sre.tools.monitorings.lib.util.helpers import (
    merge,
    unreach_skip,
    ttl,
    gen_children,
)

host = "trust.elastic"
children = ["ps-elastic"]

log_stash = [
    "ps-elastic04h.yandex.ru",
    "ps-elastic05h.yandex.ru",
    "ps-elastic06h.yandex.ru",
]
elastic_nginx = ["ps-elastic01h.yandex.ru", "ps-elastic04h.yandex.ru"]
extra_unreach = [
    "balance.balance-back",
    "balance.balance-front-int",
    "balance.balance-front-ext",
    "tech.stable",
    "trust.hw.iva",
    "trust.hw.sas",
    "trust.hw.myt",
    "trust.hw.vla",
    "octopus.octopus",
    "apikeys.stable",
]


def checks():
    checks = merge(
        common(children),
        {"es-frozen-indexes": merge(ttl(4000, 3700), unreach_skip)},
        graphite_check(
            "es-java-heap",
            "maxSeries(one_min.ps-elastic*h_yandex_ru.elasticsearch.jvm.mem.heap_used_percent)",
            92,
            75,
            "-20min",
        ),
        {"es-ps-bkp-kibana": merge(ttl(129600, 300), logic_and)},
        {
            "UNREACHABLE-" + group: gen_children([group], "UNREACHABLE", "HOST")
            for group in extra_unreach
        },
        {
            "elastic-nginx-errors": merge(
                logic_and, gen_children(elastic_nginx, "elastic-nginx-errors", "HOST")
            )
        },
        {"es-service": {}},
        {"es-status": {}},
        {"es-tweak": merge(logic_and, ttl(100000, 8192))},
        {"ls-nginx": gen_children(log_stash, "ls-nginx", "HOST")},
        pkgver,
        cpu_usage(children),
    )

    # Elastic constantly consuming a lot of cpu so it is no problem
    checks.pop("watchdog")

    return checks
