from paysys.sre.tools.monitorings.lib.checks.base import common, unreach_skip, pkgver
from paysys.sre.tools.monitorings.lib.checks.services import haproxy, ipsec
from paysys.sre.tools.monitorings.lib.util.aggregators import more_than_limit_is_crit
from paysys.sre.tools.monitorings.lib.util.helpers import merge

host = "trust.gate"
children = ["gate"]


def checks():
    return merge(
        common(children),
        merge(haproxy, {"haproxy": merge(unreach_skip, more_than_limit_is_crit(2))}),
        merge(ipsec, {"ipsec": merge(unreach_skip, more_than_limit_is_crit(2))}),
        pkgver,
    )
