from paysys.sre.tools.monitorings.configs.trust.base import rpslimiter, utils
from paysys.sre.tools.monitorings.lib.util.helpers import empty_children

host = "trust.rpslimiter"
children = empty_children

thresholds = {
    "trust_atlas_prod": utils.thresholds(5, 20),
    "trust_common_prod": utils.thresholds(5, 20),
    "trust_gateway_prod": utils.thresholds(5, 20),
    "trust_lpm_prod": utils.thresholds(20, 40),
    "trust_payments_prod": utils.thresholds(5, 20),
    "trust_paysys_prod": utils.thresholds(5, 20),
}


def checks():
    return rpslimiter.get_checks(host, thresholds.keys())


def yasm_template():
    return rpslimiter.get_yasm_template(host, thresholds)
