from paysys.sre.tools.monitorings.configs.trust.base import scheduler, utils
from paysys.sre.tools.monitorings.lib.util.helpers import empty_children

host = "trust.scheduler"
children = empty_children


queue_size_thresholds = {
    "default": utils.thresholds(250, 1000),
    # INAPP_RESYNC_SUBS
    "prod:bs_ng:INAPP_RESYNC_SUBS": utils.thresholds(500, 1000),
    # LOGBROKER
    "prod:bs_ng:LOGBROKER": utils.thresholds(2500, 5000),
    "prod:tpay_shard0:LOGBROKER": utils.thresholds(2500, 5000),
    "prod:tpay_shard1:LOGBROKER": utils.thresholds(2500, 5000),
    "prod:tpay_shard2:LOGBROKER": utils.thresholds(2500, 5000),
    "prod:tpay_shard3:LOGBROKER": utils.thresholds(2500, 5000),
    # PAYMENT_AUTO_ACTION
    "prod:bs_ng:PAYMENT_AUTO_ACTION": utils.thresholds(450000, 500000),
    "prod:tpay_shard0:PAYMENT_AUTO_ACTION": utils.thresholds(50000, 100000),
    "prod:tpay_shard1:PAYMENT_AUTO_ACTION": utils.thresholds(50000, 100000),
    "prod:tpay_shard2:PAYMENT_AUTO_ACTION": utils.thresholds(50000, 100000),
    "prod:tpay_shard3:PAYMENT_AUTO_ACTION": utils.thresholds(50000, 100000),
    # POSTAUTH
    "prod:bs_ng:POSTAUTH": utils.thresholds(2500, 5000),
    "prod:bs_xg:POSTAUTH": utils.thresholds(2500, 5000),
    "prod:tpay_shard0:POSTAUTH": utils.thresholds(2500, 5000),
    "prod:tpay_shard1:POSTAUTH": utils.thresholds(2500, 5000),
    "prod:tpay_shard2:POSTAUTH": utils.thresholds(2500, 5000),
    "prod:tpay_shard3:POSTAUTH": utils.thresholds(2500, 5000),
    # TRUST_RETRY
    "prod:bs_ng:TRUST_RETRY": utils.thresholds(4000, 5000),
    # YT_ORDER_RECOVERY
    "prod:tpay_shard0:YT_ORDER_RECOVERY": utils.thresholds(50000, 60000),
    "prod:tpay_shard1:YT_ORDER_RECOVERY": utils.thresholds(50000, 60000),
    "prod:tpay_shard2:YT_ORDER_RECOVERY": utils.thresholds(50000, 60000),
    "prod:tpay_shard3:YT_ORDER_RECOVERY": utils.thresholds(50000, 60000),
    # SUBS_RETRY_CHARGE
    "prod:bs_ng:SUBS_RETRY_CHARGE": utils.thresholds(10000, 15000),
    # SUBS_PROLONGATION
    "prod:bs_ng:SUBS_PROLONGATION": utils.thresholds(15000, 20000),

}

expired_thresholds = {
    "default": utils.thresholds(50, 100),
    # YT_ORDER_RECOVERY
    "prod:tpay_shard0:YT_ORDER_RECOVERY": utils.thresholds(100, 150),
    "prod:tpay_shard1:YT_ORDER_RECOVERY": utils.thresholds(100, 150),
    "prod:tpay_shard2:YT_ORDER_RECOVERY": utils.thresholds(100, 150),
    "prod:tpay_shard3:YT_ORDER_RECOVERY": utils.thresholds(100, 150),
}


def checks():
    return scheduler.get_checks(
        host,
        "trust.stable",
        "scheduler_prod",
        queue_size_thresholds,
        expired_thresholds,
    )
