from paysys.sre.tools.monitorings.configs.trust.base import scheduler, utils
from paysys.sre.tools.monitorings.lib.util.helpers import empty_children

host = "trust.scheduler.critical"
children = empty_children


queue_size_thresholds = {
    "default": utils.thresholds(500, 1000),
    "prod:NotifyMessage": utils.thresholds(1000, 2000),
    "prod:Payment": utils.thresholds(10000, 15000),
    "prod:Refund": utils.thresholds(2000, 4000),
}

expired_thresholds = {
    "default": utils.thresholds(50, 100),
}


def checks():
    return scheduler.get_checks(
        host,
        "trust.stable",
        "scheduler_critical_prod",
        queue_size_thresholds,
        expired_thresholds,
    )
