from paysys.sre.tools.monitorings.lib.checks.qloud import base_checks
from paysys.sre.tools.monitorings.lib.util.helpers import flaps, merge
from paysys.sre.tools.monitorings.lib.checks.postgres import postgres

app = "paysys.scrooge"
children = "paysys.scrooge.production.scrooge@type=ext"
balancer = "paysys.scrooge.scrooge.balancer-l7@type=ext"
service = "scrooge"
hostname = "scrooge.paysys.yandex.net"
env = "production"

host = "trust.scrooge"


def checks():
    return merge(
        base_checks(
            app,
            children,
            balancer,
            service,
            hostname,
            env,
        ),
        {"http_499": flaps(180, 900)},
        {"http_error": flaps(180, 900)},
        {"http_5xx": flaps(180, 900)},
        postgres("mdbq93lh32asf55tcn60", "db1", tags=["trust_postgres"])
    )
