from paysys.sre.tools.monitorings.lib.util.helpers import merge
from paysys.sre.tools.monitorings.lib.checks.rtc import rtc_monitorings
from paysys.sre.tools.monitorings.lib.util.aggregators import (
    timed_more_than_limit_is_problem,
)
from paysys.sre.tools.monitorings.lib.checks.awacs import l7_monitoring

GEOS = ['sas', 'vla']
host = "trust.terminal-selector"
children = ['terminal-selector@production']

l7_flaps = {"stable": 60, "critical": 300}

l7_checks_aggregator = {
    "aggregator": timed_more_than_limit_is_problem(
        limits=[
            {
                "day_start": 1,
                "day_end": 7,
                "time_start": 0,
                "time_end": 23,  # 23:59
                "warn": 0,
                "crit": "25%",
            },
        ]
    ),
}


l7_balancers = [
    {
        "namespace": "terminal-selector.psp.yandex.net",
        "datacenters": ["sas", "vla"],
        "host": host,
        "http_ports": [80],
        "https_ports": [443],
        "services": [
            "rtc_balancer_terminal-selector_psp_yandex_net_sas",
            "rtc_balancer_terminal-selector_psp_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 30, "crit": 50},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 0.1, "crit": 2, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 5, "crit": 10, "flaps": l7_flaps},
            "timings_q99": {"warn": 0.1, "crit": 0.2, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
]


def checks():
    return merge(
        rtc_monitorings(
            prj='psp_terminal-selector_pre_stable',
            ctype='pre_stable',
            itype='terminal-selector',
            geos=['sas']
        ),
        rtc_monitorings(
            prj='psp_terminal-selector_stable',
            ctype='stable',
            itype='terminal-selector',
            geos=GEOS
        ),
        l7_monitoring(l7_balancers, split_unreachable=True)
    )
