from paysys.sre.tools.monitorings.configs.trust.base import notifications_object, trust
from paysys.sre.tools.monitorings.lib.checks.active.http import (
    http_bundle,
    https_bundle,
)
from paysys.sre.tools.monitorings.lib.checks.base import pkgver
from paysys.sre.tools.monitorings.lib.checks.nginx_bundles import nginx_combaine_bundle
from paysys.sre.tools.monitorings.lib.checks.services import ps_ping, sox_agent
from paysys.sre.tools.monitorings.lib.util.aggregators import more_than_percent_is_crit
from paysys.sre.tools.monitorings.lib.util.helpers import (
    check,
    flaps,
    merge,
    skip_check_by_groups,
)

host = "trust.hw"
children = ["trust-back"]
split_by_dc = True

export_notify_skipped_groups = ["trust-back-iva", "trust-back-myt"]


def checks():
    base_checks = trust.get_checks(children, "psmongodb", [27017, 27018, 27019])

    base_checks.pop("mem-free", None)
    base_checks.update(
        merge(
            trust.mem_free(host, "trust.stable", "sys-stable"),
            {"mem-free": more_than_percent_is_crit(10)},
            {"mem-free": flaps(120, 300)},
        )
    )

    base_checks.pop("cpu_usage", None)
    base_checks.update(
        merge(
            trust.cpu_usage(host, "trust.stable", "sys-stable"),
            {"cpu_usage": more_than_percent_is_crit(10)},
            {"cpu_usage": flaps(180, 900)},
        )
    )

    return merge(
        base_checks,
        {"daytime": flaps(120, 300)},
        {"paysys_archiver": flaps(1800, 86400)},
        skip_check_by_groups("trust_queue_export", export_notify_skipped_groups),
        skip_check_by_groups("trust_queue_notify", export_notify_skipped_groups),
        pkgver,
        https_bundle(
            "trust-front",
            port=443,
            https_crit_expire=1,
            https_warn_expire=2,
        ),
        https_bundle(
            "yb-trust-payments",
            port=8027,
            https_crit_expire=1,
            https_warn_expire=2,
        ),
        https_bundle(
            "yb-trust-payments-ng",
            port=8028,
            https_crit_expire=1,
            https_warn_expire=2,
        ),
        https_bundle(
            "yb-trust-payments-xg",
            port=8038,
            https_crit_expire=1,
            https_warn_expire=2,
        ),
        https_bundle(
            "yb-trust-payments-callbacks-xg",
            port=8102,
            https_crit_expire=1,
            https_warn_expire=2,
        ),
        https_bundle(
            "yb-trust-paysys",
            port=8025,
            https_crit_expire=1,
            https_warn_expire=2,
        ),
        https_bundle(
            "yb-trust-paysys-mobile",
            port=8110,
            https_crit_expire=1,
            https_warn_expire=2,
        ),
        https_bundle(
            "yb-trust-paysys-web",
            port=8111,
            https_crit_expire=1,
            https_warn_expire=2,
        ),
        https_bundle(
            "yb-trust-paysys-callbacks",
            port=8112,
            https_crit_expire=1,
            https_warn_expire=2,
        ),
        https_bundle(
            "yb-trust-paysys-binding",
            port=8113,
            https_crit_expire=1,
            https_warn_expire=2,
        ),
        https_bundle(
            "yb-trust-lpm",
            port=8031,
            https_crit_expire=1,
            https_warn_expire=2,
        ),
        https_bundle(
            "yb-trust-assistant",
            port=8032,
            headers={"Host": "assistant.trust.yandex.net"},
            https_crit_expire=1,
            https_warn_expire=2,
        ),
        http_bundle("yb-trust-export", port=9001),
        http_bundle("yb-trust-export-ng", port=18091),
        http_bundle("yb-trust-export-xg", port=18036),
        http_bundle("yb-trust-notify", port=8097),
        http_bundle("yb-trust-notify-ng", port=18093),
        http_bundle("yb-trust-notify-xg", port=18037),
        skip_check_by_groups("http_yb-trust-export", export_notify_skipped_groups),
        skip_check_by_groups("http_yb-trust-export-ng", export_notify_skipped_groups),
        skip_check_by_groups("http_yb-trust-export-xg", export_notify_skipped_groups),
        skip_check_by_groups("http_yb-trust-notify", export_notify_skipped_groups),
        skip_check_by_groups("http_yb-trust-notify-ng", export_notify_skipped_groups),
        skip_check_by_groups("http_yb-trust-notify-xg", export_notify_skipped_groups),
        skip_check_by_groups(
            "http_yb-trust-export_workhours", export_notify_skipped_groups
        ),
        skip_check_by_groups(
            "http_yb-trust-export-ng_workhours", export_notify_skipped_groups
        ),
        skip_check_by_groups(
            "http_yb-trust-export-xg_workhours", export_notify_skipped_groups
        ),
        skip_check_by_groups(
            "http_yb-trust-notify_workhours", export_notify_skipped_groups
        ),
        skip_check_by_groups(
            "http_yb-trust-notify-ng_workhours", export_notify_skipped_groups
        ),
        skip_check_by_groups(
            "http_yb-trust-notify-xg_workhours", export_notify_skipped_groups
        ),
        http_bundle("jaeger-agent", port=14271, path="/"),
        http_bundle("yb-trust-worker", port=18040),
        http_bundle("yb-trust-worker-ng", port=18041),
        http_bundle("yb-trust-worker-xg", port=18042),
        https_bundle(
            "yb-logfw",
            port=8089,
            https_crit_expire=1,
            https_warn_expire=2,
        ),
        https_bundle(
            "yb-trust-directory",
            port=443,
            headers={"Host": "trust-directory.paysys.yandex.net"},
            https_crit_expire=1,
            https_warn_expire=2,
        ),
        nginx_combaine_bundle(
            conductor_children=children,
            combaine_env="prod",
            combaine_path="trust_back.nginx-trust.trust",
            crit_errors_by_host=36.0 / 60,
            warn_errors_by_host=30.0 / 60,
        ),
        {"nginx_errors": flaps(120, 600)},
        {"nginx_499_percent": flaps(120, 600)},
        nginx_combaine_bundle(
            conductor_children=children,
            combaine_env="prod",
            combaine_path="trust_back.nginx-trust.trust-lpm",
            crit_errors_by_host=15.0 / 60,
            warn_errors_by_host=9.0 / 60,
            prefix="trust-lpm",
        ),
        {"trust-lpm_nginx_errors": flaps(120, 600)},
        ps_ping,
        check("ps-closedc", flaps(180, 360)),
        sox_agent,
        {"hwerrors2": notifications_object.iron_woman_daytime},
    )
