from paysys.sre.tools.monitorings.configs.trust.base import trust_atlas
from paysys.sre.tools.monitorings.lib.checks.active.http import merge
from paysys.sre.tools.monitorings.lib.checks.rtc import rtc_monitorings

GEOS = ['sas', 'vla', 'myt']
DEPLOY_UNIT = 'api'
STAGE = 'trust-atlas-prod-stage'
WORKLOAD = 'workload-api'
host = "trust.trust-atlas"

children = ['trust-atlas@stage={stage};deploy_unit={deploy_unit}'.format(stage=STAGE, deploy_unit=DEPLOY_UNIT)]


def get_deploy_prj(deploy_unit, stage, workload):
    return "{stage}.{deploy_unit}.{workload}".format(stage=stage, deploy_unit=deploy_unit, workload=workload)


def checks():
    return merge(
        trust_atlas.get_checks(
            children
        ),
        rtc_monitorings(
            prj=get_deploy_prj(DEPLOY_UNIT, STAGE, WORKLOAD),
            ctype='none',
            itype='deploy',
            geos=GEOS
        )
    )
