from paysys.sre.tools.monitorings.lib.checks.awacs import l7_monitoring
from paysys.sre.tools.monitorings.lib.util.aggregators import (
    timed_more_than_limit_is_problem,
)
from paysys.sre.tools.monitorings.lib.util.helpers import empty_children


host = "trust.l7"

children = empty_children

l7_flaps = {"stable": 60, "critical": 300}

l7_checks_aggregator = {
    "aggregator": timed_more_than_limit_is_problem(
        limits=[
            {
                "day_start": 1,
                "day_end": 7,
                "time_start": 0,
                "time_end": 23,  # 23:59
                "warn": 0,
                "crit": "25%",
            },
        ]
    ),
}

l7_balancers = [
    {
        "namespace": "trust-payments-xg-l7.paysys.yandex.net",
        "datacenters": ["myt", "sas", "vla"],
        "host": "trust-payments-xg.paysys.yandex.net",
        "http_ports": [],
        "https_ports": [8038],
        "services": [
            "rtc_balancer_trust-payments-xg-l7_paysys_yandex_net_myt",
            "rtc_balancer_trust-payments-xg-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-payments-xg-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 3, "crit": 6, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 5, "crit": 10, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
    {
        "namespace": "trust-lpm-l7.paysys.yandex.net",
        "datacenters": ["myt", "sas", "vla"],
        "host": "trust-lpm.paysys.yandex.net",
        "http_ports": [],
        "https_ports": [8031],
        "services": [
            "rtc_balancer_trust-lpm-l7_paysys_yandex_net_myt",
            "rtc_balancer_trust-lpm-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-lpm-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 2, "crit": 4, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 1, "crit": 2, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
    {
        "namespace": "trust-directory-l7.paysys.yandex.net",
        "datacenters": ["myt", "sas", "vla"],
        "host": "trust-directory.paysys.yandex.net",
        "http_ports": [],
        "https_ports": [443],
        "services": [
            "rtc_balancer_trust-directory-l7_paysys_yandex_net_myt",
            "rtc_balancer_trust-directory-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-directory-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 1, "crit": 2, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 1, "crit": 2, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
    {
        "namespace": "trust-payments-l7.paysys.yandex.net",
        "datacenters": ["myt", "sas", "vla"],
        "host": "trust-payments.paysys.yandex.net",
        "http_ports": [],
        "https_ports": [8028],
        "services": [
            "rtc_balancer_trust-payments-l7_paysys_yandex_net_myt",
            "rtc_balancer_trust-payments-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-payments-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            # TODO: decrease thresholds after MARKETCHECKOUT-24835
            "codes_5xx": {"warn": 2, "crit": 4, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 1, "crit": 2, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
    {
        "namespace": "trust-payments-old-l7.paysys.yandex.net",
        "datacenters": ["myt", "sas", "vla"],
        "host": "trust-payments-old.paysys.yandex.net",
        "http_ports": [],
        "https_ports": [8027],
        "services": [
            "rtc_balancer_trust-payments-old-l7_paysys_yandex_net_myt",
            "rtc_balancer_trust-payments-old-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-payments-old-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 2, "crit": 5, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 1, "crit": 2, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
    {
        "namespace": "trust-paysys-l7.paysys.yandex.net",
        "datacenters": ["myt", "sas", "vla"],
        "host": "trust-paysys.paysys.yandex.net",
        "http_ports": [],
        "https_ports": [8025],
        "services": [
            "rtc_balancer_trust-paysys-l7_paysys_yandex_net_myt",
            "rtc_balancer_trust-paysys-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-paysys-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 1, "crit": 2, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 1, "crit": 2, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
    {
        "namespace": "trust-l7.paysys.yandex.net",
        "datacenters": ["myt", "sas", "vla"],
        "host": "trust.yandex.net",
        "http_ports": [],
        "https_ports": [443],
        "services": [
            "rtc_balancer_trust-l7_paysys_yandex_net_myt",
            "rtc_balancer_trust-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 2, "crit": 4, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 5, "crit": 10, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
    {
        "namespace": "trust-assistant-l7.paysys.yandex.net",
        "datacenters": ["myt", "sas", "vla"],
        "host": "assistant.trust.yandex.net",
        "http_ports": [],
        "https_ports": [443],
        "services": [
            "rtc_balancer_trust-assistant-l7_paysys_yandex_net_myt",
            "rtc_balancer_trust-assistant-l7_paysys_yandex_net_sas",
            "rtc_balancer_trust-assistant-l7_paysys_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 1, "crit": 2, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 1, "crit": 2, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
    {
        "namespace": "scheduler.trust.yandex.net",
        "datacenters": ["myt", "sas", "vla"],
        "host": "scheduler.trust.yandex.net",
        "http_ports": [],
        "https_ports": [443],
        "services": [
            "rtc_balancer_scheduler_trust_yandex_net_myt",
            "rtc_balancer_scheduler_trust_yandex_net_sas",
            "rtc_balancer_scheduler_trust_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 1, "crit": 2, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 1, "crit": 2, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
    {
        "namespace": "scheduler-critical.trust.yandex.net",
        "datacenters": ["myt", "sas", "vla"],
        "host": "scheduler-critical.trust.yandex.net",
        "http_ports": [],
        "https_ports": [443],
        "services": [
            "rtc_balancer_scheduler-critical_trust_yandex_net_myt",
            "rtc_balancer_scheduler-critical_trust_yandex_net_sas",
            "rtc_balancer_scheduler-critical_trust_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 1, "crit": 2, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 1, "crit": 2, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
    {
        "namespace": "callback.trust.yandex.net",
        "datacenters": ["myt", "sas", "vla"],
        "host": "callback.trust.yandex.net",
        "http_ports": [],
        "https_ports": [443],
        "services": [
            "rtc_balancer_callback_trust_yandex_net_myt",
            "rtc_balancer_callback_trust_yandex_net_sas",
            "rtc_balancer_callback_trust_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 1, "crit": 2, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 1, "crit": 2, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
    {
        "namespace": "api.trust.yandex.net",
        "datacenters": ["man", "sas", "vla"],
        "host": "api.trust.yandex.net",
        "http_ports": [],
        "https_ports": [443],
        "services": [
            "rtc_balancer_api_trust_yandex_net_man",
            "rtc_balancer_api_trust_yandex_net_sas",
            "rtc_balancer_api_trust_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 1, "crit": 2, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 1, "crit": 2, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
    {
        "namespace": "atlas.trust.yandex.net",
        "datacenters": ["myt", "sas", "vla"],
        "host": "atlas.trust.yandex.net",
        "http_ports": [],
        "https_ports": [443],
        "services": [
            "rtc_balancer_atlas_trust_yandex_net_myt",
            "rtc_balancer_atlas_trust_yandex_net_sas",
            "rtc_balancer_atlas_trust_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 1, "crit": 2, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 1, "crit": 2, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
    {
        "namespace": "sentry.trust.yandex.net",
        "datacenters": ["man", "sas", "vla"],
        "host": "sentry.trust.yandex.net",
        "http_ports": [],
        "https_ports": [443],
        "services": [
            "rtc_balancer_sentry_trust_yandex_net_man",
            "rtc_balancer_sentry_trust_yandex_net_sas",
            "rtc_balancer_sentry_trust_yandex_net_vla",
        ],
        "checks": {
            "cpu_usage": {"warn": 60, "crit": 80},
            "cpu_wait": {"warn": 0.5, "crit": 1},
            "codes_5xx": {"warn": 1, "crit": 2, "flaps": l7_flaps},
            "attempts_backend_errors": {"warn": 1, "crit": 2, "flaps": l7_flaps},
        },
        "http_checks": l7_checks_aggregator,
        "instance_checks": l7_checks_aggregator,
    },
]


def checks():
    return l7_monitoring(l7_balancers, split_unreachable=True)
