from paysys.sre.tools.monitorings.configs.trust.base import trust_mongo
from paysys.sre.tools.monitorings.lib.checks.base import (
    pkgver, mem_free, disk_ssd, cpu_usage, link_utilization_graphite, BYTES_IN_GIGABIT
)
from paysys.sre.tools.monitorings.lib.checks.services import sox_agent
from paysys.sre.tools.monitorings.lib.util.helpers import merge

host = "trust.mongo"

children = ['psmongodb']

split_by_dc = True


def checks():
    return merge(
        trust_mongo.get_checks(
            children, 'psmongodb', 3, split_by_dc, host,
            warn=400000, crit=500000,
            warn_ratio=3.0, crit_ratio=4.0,
            warn_oplog=72, crit_oplog=48,
        ),
        trust_mongo.spinlock_delay(host, 27103, "mongo", "trust.stable", 300, 600),
        pkgver,
        mem_free(children, warn=0.8, crit=0.85),
        disk_ssd(children),
        cpu_usage(children),
        link_utilization_graphite(children, warn=0.4, crit=0.4, max=BYTES_IN_GIGABIT*10),
        sox_agent
    )
