from paysys.sre.tools.monitorings.configs.paysys.base import mongo_backup
from paysys.sre.tools.monitorings.lib.checks.base import pkgver
from paysys.sre.tools.monitorings.lib.util.aggregators import (
    timed_more_than_limit_is_problem,
)
from paysys.sre.tools.monitorings.lib.util.helpers import merge, update_checks
from paysys.sre.tools.monitorings.configs.paysys.base import notifications_object

host = "trust.mongo.backup"

children = ["trust-mongobckp-prod"]


def checks():
    mongo_rs_lag = {
        "mongo_rs_lag": timed_more_than_limit_is_problem(
            limits=[
                # backup-mongo.py starts at 1:00. Suppose that it ends before 3:59.
                # If the current time does not fall under any of the limits,
                # the aggregate turns into logic_or.
                {
                    "day_start": 1,
                    "day_end": 7,
                    "time_start": 1,
                    "time_end": 3,
                    "warn": 0,
                    "crit": 1,
                },
            ]
        ),
    }
    result = merge(
        mongo_backup.get_checks(children, "psmongodb", 3),
        mongo_rs_lag,
        pkgver,
    )
    return update_checks(result, notifications_object.noop)
