from paysys.sre.tools.monitorings.lib.checks.postgres import postgres
from paysys.sre.tools.monitorings.lib.util.helpers import merge

host = "trust.postgres"

children = []

tags = ["trust_postgres"]
sentry_tags = ["trust_sentry_postgres"]


def checks():
    return merge(
        postgres(
            cluster_id="c08a2ac2-9181-4ac7-bb88-e8ad1505de1a",
            db_name="trust_payments_prod",
            conn_limit=200,
            users=[
                "trust_directory_app",
                "trust_export_ng_app",
                "trust_export_xg_app",
                "trust_gateway",
                "trust_notify_ng_app",
                "trust_notify_xg_app",
                "trust_worker_ng_app",
                "trust_worker_app",
                "trust_payments_app",
                "trust_payments_xg_app",
            ],
            tags=tags,
            cpu_wait_limit=2.5,
        ),
        postgres(
            cluster_id="mdb0rrokp792as89r8q4",
            db_name="trust_receipts_prod",
            conn_limit=1000,
            users=["trust_receipts_app"],
            tags=tags,
        ),
        postgres(
            cluster_name="trust_payments_shard1",
            cluster_id="mdb85peqc29ujv0d30qq",
            db_name="trust_payments_prod",
            conn_limit=300,
            users=[
                "trust_export",
                "trust_notify",
                "trust_payments_app",
                "trust_payments",
                "trust_utility",
                "trust_worker_app",
            ],
            tags=tags,
        ),
        postgres(
            cluster_name="trust_payments_shard2",
            cluster_id="mdb01d83f51t2196u8np",
            db_name="trust_payments_prod",
            conn_limit=300,
            users=[
                "trust_export",
                "trust_notify",
                "trust_payments_app",
                "trust_payments",
                "trust_utility",
                "trust_worker_app",
            ],
            tags=tags,
        ),
        postgres(
            cluster_name="trust_payments_shard3",
            cluster_id="mdbe3anfbk7t5h9c5k3l",
            db_name="trust_payments_prod",
            conn_limit=300,
            users=[
                "trust_export",
                "trust_notify",
                "trust_payments_app",
                "trust_payments",
                "trust_utility",
                "trust_worker_app",
            ],
            tags=tags,
        ),
        postgres(
            cluster_name="trust_gomer_prod",
            cluster_id="mdbk5m75fkhs6u5p5c19",
            db_name="trust_gomer_prod",
            conn_limit=500,
            users=["trust_gomer_app"],
            tags=tags,
        ),
        postgres(
            cluster_name="trust_metadata_prod",
            cluster_id="mdbhnog4eb2s7coka3md",
            db_name="trust_metadata_prod",
            conn_limit=500,
            users=["trust_metadata_app"],
            tags=tags,
        ),
        postgres(
            cluster_name="trust_scheduler_prod",
            cluster_id="mdbdcoiau7op06qba1dc",
            db_name="trust_scheduler_prod",
            conn_limit=50,
            users=["trust_scheduler_user"],
            tags=tags,
        ),
        postgres(
            cluster_name="trust_sentry_prod",
            cluster_id="mdbp8brdg63n00u2v7t0",
            db_name="trust_sentry_prod",
            conn_limit=100,
            query_time_limit=30,  # ms
            cpu_wait_limit=4.0,  # don't check them
            tags=sentry_tags,
        ),
        postgres(
            cluster_name="trust_utility_prod",
            cluster_id="mdbdqnshlmbv28a3hpu9",
            db_name="trust_utility_prod",
            conn_limit=100,
            disk_space_warn_threshold=60,
            disk_space_crit_threshold=80,
            tags=tags,
        ),
        postgres(
            cluster_name="trust_scheduler_critical_prod",
            cluster_id="mdbe73i21670ll7b5m2p",
            db_name="trust_scheduler_critical_prod",
            conn_limit=100,
            disk_space_warn_threshold=60,
            disk_space_crit_threshold=80,
            tags=tags,
        )
    )
