from paysys.sre.tools.monitorings.lib.checks.qloud import base_checks
from paysys.sre.tools.monitorings.lib.util.helpers import merge, update_checks
from paysys.sre.tools.monitorings.configs.paysys.base import ESCALATION_USERS
from paysys.sre.tools.monitorings.configs.paysys.base import TELEGRAM_GROUP, CALENDAR_ID
from paysys.sre.tools.monitorings.lib.notifications import Notifications

app = "paysys.uzcard3ds"
children = "paysys.uzcard3ds.prod.nodejs@type=ext"
balancer = "paysys.uzcard3ds.uzcard-3ds.balancer-l7@type=ext"
service = "uzcard3ds"
hostname = "uzcard-3ds.paysys.yandex.net"
env = "prod"
trust_chat = ["trust_telegram"]

notifications = Notifications()\
    .set_iron_woman(delay=1200, logins=ESCALATION_USERS)\
    .set_calendar(CALENDAR_ID)\
    .set_telegram(TELEGRAM_GROUP + trust_chat)\
    .iron_woman_and_sms_and_telegram_critonly

host = "trust.uzcard3ds"


def checks():
    return update_checks(
        merge(
            base_checks(
                app,
                children,
                balancer,
                service,
                hostname,
                env,
                http_error_crit=6.0,
                http_499_crit=6.0,
                http_5xx_crit=6.0,
            ),
        ),
        notifications)
