from paysys.sre.tools.monitorings.lib.checks.yt import yt_used_space
from paysys.sre.tools.monitorings.lib.util.helpers import merge
from paysys.sre.tools.monitorings.lib.util.aggregators import empty_kwargs

host = "trust.yt"
children = []

PAYSYS_ACCOUNT = "paysys"


def checks():
    return merge(
        yt_used_space(
            PAYSYS_ACCOUNT,
            "trust",
            warn_percent_threshold=0.5,
            crit_percent_threshold=0.6,
            custom_selectors={"medium": "default", "cluster": "locke", "host": "*"},
        ),
        yt_used_space(
            PAYSYS_ACCOUNT,
            "trust",
            warn_percent_threshold=0.95,
            crit_percent_threshold=0.97,
            custom_selectors={"medium": "default", "cluster": "hahn", "host": "*"},
        ),
        yt_used_space(
            PAYSYS_ACCOUNT,
            "trust",
            warn_percent_threshold=0.95,
            crit_percent_threshold=0.97,
            custom_selectors={"medium": "default", "cluster": "arnold", "host": "*"},
        ),
        yt_used_space(
            PAYSYS_ACCOUNT,
            "trust-analytics",
            warn_percent_threshold=0.95,
            crit_percent_threshold=0.97,
            custom_selectors={"medium": "default", "cluster": "hahn", "host": "*"},
        ),
        yt_used_space(
            PAYSYS_ACCOUNT,
            "payplatform",
            warn_percent_threshold=0.80,
            crit_percent_threshold=0.90,
            custom_selectors={"medium": "default", "cluster": "hahn", "host": "*"},
        ),
        {"locke-trust-used-space": empty_kwargs},
        {"hahn-trust-used-space": empty_kwargs},
        {"arnold-trust-used-space": empty_kwargs},
        {"hahn-trust-analytics-used-space": empty_kwargs},
        {"hahn-payplatform-used-space": empty_kwargs},
    )
