from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, flaps
from paysys.sre.tools.monitorings.lib.notifications import Notifications, UZEDO_ESCALATION_USERS

defaults = merge(
    flaps(240, 0),
    ttl(620, 60),
    {'namespace': 'uzedo.stable'},
)

notifications_object = Notifications()
notifications_object.set_iron_woman(logins=UZEDO_ESCALATION_USERS)
notifications_object.set_telegram('yndx-uzedo-duty-monitoring')
notifications_object.set_startrek('UZEDOADMIN', status='CRIT', components='monitoring', priority='critical')

notifications = {
    'default': notifications_object.noop,
    'by_service': {
        'mds-unispace': notifications_object.iron_woman_daytime_and_startrek_and_telegram_critonly
    }
}

CONFIGS = [
    "uzedo7736207543",
    "uzedo7704340310",
    "uzedo7704340327",
    "uzedo7704357909",
    "uzedo7704448842_health",
    "uzedo7704458262_cloud",
    "uzedo7704460769_fuel",
    "uzedo7707666550_jams",
    "uzedo9705114405_food",
    "uzedo9705121040_mediaservices",
    "uzedo_stable",
]

for conf in CONFIGS:
    conf = conf.replace('_', '-')
    notifications['by_service']['{0}-pg-unispace'.format(conf)] = notifications_object.iron_woman_daytime_and_startrek_and_telegram_critonly
