from paysys.sre.tools.monitorings.lib.util.helpers import merge
from paysys.sre.tools.monitorings.lib.checks.mds import mds
from paysys.sre.tools.monitorings.lib.checks.postgres import postgres
from paysys.sre.tools.monitorings.lib.notifications import Notifications

children = "paysys.uzedo-stable.production.uzedo-stable@type=ext"
env = "production"

host = "uzedo-stable.{}".format(env)

notifications = Notifications().set_startrek(
    queue="OEBSSUPPORT",
    components=["oebs-monitoring"],
    priority="critical",
    assignee="voznesensky",
    followers=[
        "kasparova",
        "dunduev",
        "monataly",
        "urusova13",
    ],
    on_dashboard=False,
)


def checks():
    result = merge(
        mds("production", "uzedo"),
        postgres("mdb5pgdubaclu76u9dgp", "uzedo-stable", flaps_critical=0),
    )
    return result
