from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, flaps, check, gen_children
from paysys.sre.tools.monitorings.lib.checks import base, services


def get_checks(children):
    checks = merge(
        base.common_fin_fin(children),
        services.check_slb,
        check('database_audit_size', ttl(7200, 3600), gen_children(children, 'vrt_audit_size')),
        check('vcpuperf', ttl(7200, 3600), gen_children(children, 'vrt_vcpuperf')),
        check('database_backup', merge(ttl(1800, 1200), flaps(1800, 3000)), gen_children(
            children, ['vrt_backup_status', 'vrt_backup_status_file_is_obsolete'])),
        check('database_config', ttl(7200, 3600), gen_children(
            children, [
                'vrt_database_parameters',
                'vrt_load_balancer_policy',
                'vrt_resource_pools',
                'vrt_version'
            ])),
        check('database_copycluster', ttl(2400, 1200), gen_children(
            children, ['vrt_copycluster_status', 'vrt_copycluster_status_file_is_obsolete'])),
        check('database_health', ttl(600, 300), gen_children(
            children, [
                'vrt_nodes_status',
                'vrt_port_is_listened',
                'vrt_database_is_active',
                'vrt_database_is_active_in_standby_dc'
            ]))
    )

    return checks
