from paysys.sre.tools.monitorings.lib.util.helpers import merge
from paysys.sre.tools.monitorings.lib.checks.base import pkgver, disk_ssd, cpu_usage
from paysys.sre.tools.monitorings.lib.checks.nginx_bundles import nginx_combaine_bundle
from paysys.sre.tools.monitorings.lib.checks.active.http import https_bundle
from paysys.sre.tools.monitorings.configs.whitespirit.base import whitespirit


host = "whitespirit"


children = ['whitespirit']


settings = [
    "new-7704340310",
    7704340327,
    7704448440,
    7710688352,
    7736207543,
]


def checks():
    """
    :return: dict with whitespirit stable checks
    """
    return merge(
        whitespirit.get_checks(children),
        {'mem-free': {
            "aggregator": "timed_more_than_limit_is_problem",
            "aggregator_kwargs": {
                "limits": [
                    {
                        "crit": 0,
                        "day_end": 7,
                        "day_start": 1,
                        "time_end": 23,
                        "time_start": 0,
                        "warn": 0
                    }
                ],
                "nodata_mode": "skip"
            }
        }},
        pkgver,
        disk_ssd(children),
        cpu_usage(children),
        nginx_combaine_bundle(
            conductor_children=children,
            combaine_env='prod',
            combaine_path='whitespirit.nginx-whitespirit.whitespirit',
            crit_errors_by_host=8.0 / 60
        ),
        https_bundle(
            'balance-hudsucker',
            port=8081,
            headers={'Host': 'balance-hudsucker.paysys.yandex.net'},
        ),
        *[https_bundle(
            'whitespirit_{0}'.format(x),
            port=8080,
            headers={'Host': '{0}.whitespirit.paysys.yandex.net'.format(x)},
            crit=4,
            warn=4,
            crit_workhours=4,
            warn_workhours=4,
        ) for x in settings]
    )
