from paysys.sre.tools.monitorings.lib.checks import services, base
from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, check, unreach_skip
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, logic_or, downtime_skip


def get_checks(children):

    exclude_db_checks = ['oracle-status', 'shared_pool_free_mem', 'mvlogmove', 'psdbstat', 'ps_ts_info', 'ps_segment_info',
                         'matview-refresh', 'matview-monitor', 'oracle_memory_usage']
    database_result = services.oracle_database.copy()
    [database_result.pop(exclude) for exclude in exclude_db_checks]

    exclude_rac_checks = ['crs-autostart', 'iscsi-ips', 'iscsi-params', 'oracle-patches']
    rac_result = services.oracle_rac.copy()
    [rac_result.pop(exclude) for exclude in exclude_rac_checks]

    exclude_host_checks = ['bmc', 'check-certs', 'clock', 'cpu', 'daytime', 'disk', 'ecc', 'gpu',
                           'hwerrors2', 'link', 'link-speed', 'mem', 'ntp-stratum', 'raid', 'raid_check_speed']
    host_result = base.host.copy()
    [host_result.pop(exclude) for exclude in exclude_host_checks]

    return merge(database_result,
                 rac_result,
                 host_result,
                 services.audit,
                 base.check_configs,
                 base.host_memory_usage,
                 base.load_average_paysys,
                 base.sysctl,
                 base.unbound,
                 base.unispace5,
                 check('oracle-balance-patches', merge(ttl(5400, 3600), logic_or, unreach_skip, downtime_skip)),
                 check('seq-check', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)))
