from paysys.sre.tools.monitorings.lib.util.helpers import merge, ttl, flaps, check, unreach_skip, gen_children, gen_unreach_by_service, cleanup_unreacheable
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, downtime_skip, logic_or
from paysys.sre.tools.monitorings.configs.yabank.base import database


host = "yabank.dev.db"  # VIRT HOST
children = ['abs-ora-db-test-vla-01.npe.yandex-bank.net', 'abs-ora-db-dev-vla-01.npe.yandex-bank.net']


def checks():
    result = merge(database.get_checks(children),
                   check('oracle-status-cft1', merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip)),
                   check('uptime', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'uptime'),
                                         logic_or, unreach_skip, downtime_skip)),
                   check('grid-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'grid-up'),
                                          logic_or, unreach_skip, downtime_skip)),
                   check('database-up', merge(flaps(900, 0), ttl(630, 330), gen_children(children, 'database-up'),
                                              logic_or, unreach_skip, downtime_skip)),
                   )
    for k in result.keys():
        result[k].update(gen_children(children, k, group_type="HOST"))
    result = gen_unreach_by_service(result)
    result = cleanup_unreacheable(result)
    return result
