from paysys.sre.tools.monitorings.lib.notifications import (
    YB_LOG_TARIFF_MONITORINGS_GROUP,
    Notifications,
)
from paysys.sre.tools.monitorings.configs.balance_app.base import (
    core_duty_notifications_object
)

CONFIGS = [
    "unprocessed_rows",
    "cycle_delay",
    "oltp_errors",
]

SOLOMON_PROJECT = "yb_log_tariff"
JUGGLER_HOST = "yb_log_tariff_stable"

# Current metrics job schedule is to run every 5 minutes.
# We have to set such a big window size,
# because occasionally the job can work for up to 45 minutes for various reasons.
METRICS_WINDOW_SECS = 60 * 60

TARIFF_CYCLE_THRESHOLD_SECS = 16000  # =~ 266 minutes =~ 4.5 hours

defaults = {'namespace': 'yb.log.tariff'}

telegram_notification = Notifications().set_telegram(YB_LOG_TARIFF_MONITORINGS_GROUP).telegram
notifications = {
    'default': telegram_notification,
    'by_tag': {
        'cycle_delay_check': core_duty_notifications_object.iron_woman_daytime_and_telegram
    }
}
