from paysys.sre.tools.monitorings.lib.util.helpers import (
    solomon_check,
    merge,
    empty_children,
)
from paysys.sre.tools.monitorings.lib.util.solomon import (
    solomon_expression_custom,
    selectors_to_string,
)
from paysys.sre.tools.monitorings.configs.yb_log_tariff.stable import (
    SOLOMON_PROJECT,
    JUGGLER_HOST,
    METRICS_WINDOW_SECS,
    TARIFF_CYCLE_THRESHOLD_SECS,
)
from paysys.sre.tools.monitorings.configs.yb_log_tariff import (
    YT_CLUSTERS,
)


# required variables
host = JUGGLER_HOST
children = empty_children


def checks():
    checks_ = {}

    param_groups = [
        {
            "name": "tariff",
            "folder": "log_tariff/public/income/bs/tariffed_events",
            "threshold": TARIFF_CYCLE_THRESHOLD_SECS,
        },
        {
            "name": "interim_acts",
            "folder": "log_tariff/public/income/bs/acted_events",
            "threshold": 22000,
        }
    ]

    for yt_cluster in YT_CLUSTERS:
        for params in param_groups:
            selectors = {
                "cluster": "prod",
                "service": "yt_log_tariff",
                "sensor": "last_table_creation_time",
                "host": yt_cluster,
                "folder": params["folder"],
                "project": "balance",
            }

            metric_name = "%s_delay_%s" % (params["name"], yt_cluster)
            program = (
                "let metric = {selectors};\n"
                "let no_data = (count(metric) == 0);\n"
                "let current_value = last(metric);\n"
                "let metric_name = \"{metric_name}\";\n"
                "let description = no_data ? \"No data\" : (\"Last table was created \" + current_value + \" seconds ago.\");\n"
                "alarm_if(no_data);\n"
                "alarm_if(current_value > {threshold});\n"
            ).format(
                selectors=selectors_to_string(selectors),
                threshold=params["threshold"],
                metric_name=metric_name,
            )

            expr = solomon_expression_custom(
                program_str=program,
                project_id=SOLOMON_PROJECT,
                annotations={
                    "description": "{{expression.description}}",
                    "metric_name": "{{expression.metric_name}}"
                },
                window_secs=METRICS_WINDOW_SECS,
            )

            checks_ = merge(
                checks_,
                solomon_check(
                    metric_name,
                    expr,
                    {
                        "aggregator_kwargs": {
                            "nodata_mode": "force_crit",
                        },
                    },
                ),
                {metric_name: {"tags": ["cycle_delay_check"]}},
            )

    return checks_
