from paysys.sre.tools.monitorings.lib.util.helpers import (
    solomon_check,
    empty_children,
)
from paysys.sre.tools.monitorings.lib.util.solomon import (
    solomon_expression_custom,
    selectors_to_string,
)
from paysys.sre.tools.monitorings.configs.yb_log_tariff.stable import (
    SOLOMON_PROJECT,
    JUGGLER_HOST,
    TARIFF_CYCLE_THRESHOLD_SECS,
)


# required variables
host = JUGGLER_HOST
children = empty_children


def checks():
    selectors = {
        "cluster": "prod",
        "service": "core",
        "name": "oltp_errors",
        "project": "yb_log_tariff",
    }

    program = (
        "let metric = {selectors};\n"
        "let no_data = (count(metric) == 0);\n"
        "let current_value = last(metric);\n"
        "let metric_name = \"{metric_name}\";\n"
        "let description = no_data ? \"No data\" : (\"There are \" + current_value + \" errors in the last OLTP step output.\");\n"
        "alarm_if(no_data);\n"
        "alarm_if(current_value > 0);\n"
    ).format(
        selectors=selectors_to_string(selectors),
        metric_name=selectors["name"],
    )

    expr = solomon_expression_custom(
        program_str=program,
        project_id=SOLOMON_PROJECT,
        annotations={
            "description": "{{expression.description}}",
            "metric_name": "{{expression.metric_name}}"
        },
        window_secs=TARIFF_CYCLE_THRESHOLD_SECS,
    )

    return solomon_check(
        "oltp_errors_count",
        expr,
        {
            "aggregator_kwargs": {
                "nodata_mode": "force_crit",
            },
        },
    )
