from paysys.sre.tools.monitorings.lib.util.helpers import (
    solomon_check,
    merge,
    empty_children,
)
from paysys.sre.tools.monitorings.lib.util.solomon import (
    solomon_expression_custom,
    selectors_to_string,
)
from paysys.sre.tools.monitorings.configs.yb_log_tariff.stable import (
    SOLOMON_PROJECT,
    JUGGLER_HOST,
    METRICS_WINDOW_SECS,
)
from paysys.sre.tools.monitorings.configs.yb_log_tariff import (
    YT_CLUSTERS,
)


# required variables
host = JUGGLER_HOST
children = empty_children


def checks():
    checks_ = {}

    param_groups = [
        {
            "name": "untariffed_events",
            "folder": "log_tariff/shadow/income/bs/tariff/untariffed/stripped",
            "threshold": 60000000,
        },
        {
            "name": "acts_unprocessed_events",
            "folder": "log_tariff/shadow/income/bs/acts/unprocessed_events/stripped",
            "threshold": 10000000
        }
    ]

    for yt_cluster in YT_CLUSTERS:
        for params in param_groups:
            selectors = {
                "cluster": "prod",
                "service": "yt_log_tariff",
                "sensor": "last_table_row_count",
                "host": yt_cluster,
                "folder": params["folder"],
                "project": "balance",
            }

            program = (
                "let metric = {selectors};\n"
                "let no_data = (count(metric) == 0);\n"
                "let current_value = last(metric);\n"
                "let metric_name = \"{metric_name}\";\n"
                "let description = no_data ? \"No data\" : (\"Current value is \" + current_value);\n"
                "alarm_if(no_data);\n"
                "alarm_if(current_value > {threshold});\n"
            ).format(
                selectors=selectors_to_string(selectors),
                metric_name=params["name"],
                threshold=params["threshold"],
            )

            expr = solomon_expression_custom(
                program_str=program,
                project_id=SOLOMON_PROJECT,
                annotations={
                    "description": "{{expression.description}}",
                    "metric_name": "{{expression.metric_name}}"
                },
                window_secs=METRICS_WINDOW_SECS,
            )

            checks_ = merge(checks_, solomon_check(
                "%s_count_%s" % (params["name"], yt_cluster),
                expr,
                {
                    "aggregator_kwargs": {
                        "nodata_mode": "force_crit"
                    },
                },
            ))

    return checks_
