#!/usr/bin/env bash

if [ $# -ne 2 ]; then
  echo "USAGE: $0 hostA hostB"
  exit
fi

A=$1
B=$2

juggler-sdk dump --host "$A" | jq '.[] |= with_entries(select(.key == "host" and .value == "'${A}'" | not)) | del(.[].tags) | del(.[].methods) ' > jq-diff-"${A}".json
juggler-sdk dump --host "$B" | jq '.[] |= with_entries(select(.key == "host" and .value == "'${B}'" | not)) | del(.[].tags) | del(.[].notifications)' > jq-diff-"${B}".json
meld jq-diff-"${A}".json jq-diff-"${B}".json
rm jq-diff-"${A}".json jq-diff-"${B}".json
