from paysys.sre.tools.monitorings.lib.util.helpers import merge, unreach_skip, flaps


def ssh(name, host):
    return {
        name: merge({
            'active': 'ssh',
            'active_kwargs': {
                'host': host
            }
        })
    }


def tcp_chat(name, port=80, timeout=15, chat=[["", "", ""]], use_all_dc=False, refresh_time=90,
             disable_ipv4=False, disable_ipv6=False, aggr_mode='best', flaps_stable=None,
             flaps_critical=None):
    flaps_enabled = False
    if any([flaps_stable, flaps_critical]):
        flaps_enabled = True

    if flaps_stable is None:
        flaps_stable = refresh_time * 3
    if flaps_critical is None:
        flaps_critical = flaps_stable * 5

    tcp_chat_result = {
        name: merge(
            {
                'active': 'tcp_chat',
                'active_kwargs': {
                    'port': port,
                    'timeout': timeout,
                    'chat': chat,
                    'use_all_dc': use_all_dc,
                    'disable_ipv4': disable_ipv4,
                    'disable_ipv6': disable_ipv6,
                    'aggr_mode': aggr_mode
                },
                'refresh_time': refresh_time
            },
            unreach_skip,
            flaps(flaps_stable, flaps_critical) if flaps_enabled else {}
        )
    }

    return tcp_chat_result


def icmpping(name, use_all_dc=False, refresh_time=90, disable_ipv4=False, disable_ipv6=False, aggr_mode='best',
             flaps_stable=None, flaps_critical=None):
    flaps_enabled = False
    if any([flaps_stable, flaps_critical]):
        flaps_enabled = True

    if flaps_stable is None:
        flaps_stable = refresh_time * 3
    if flaps_critical is None:
        flaps_critical = flaps_stable * 5

    icmpping_result = {
        name: merge(
            {
                'active': 'icmpping',
                'active_kwargs': {
                    'use_all_dc': use_all_dc,
                    'disable_ipv4': disable_ipv4,
                    'disable_ipv6': disable_ipv6,
                    'aggr_mode': aggr_mode
                },
                'refresh_time': refresh_time
            },
            unreach_skip,
            flaps(flaps_stable, flaps_critical) if flaps_enabled else {}
        )
    }

    return icmpping_result
