wiki_base_url = "https://wiki.yandex-team.ru/DljaAdminov/paysys/BalanceITDocs/Monitoring"


def doc(url, title="Documentation"):
    return {
        'meta': {
            'urls': [
                {
                    "title": title,
                    "url": url,
                    "type": 'wiki'
                }
            ]
        }
    }


def doc_link(anchor):
    return doc(wiki_base_url + '/#{0}'.format(anchor))


def mview_doc_link(anchor="monitoring"):
    url = 'https://wiki.yandex-team.ru/oebsadmin/optimizacija-proizvoditelnosti/proizvoditelnost-i-monitoring-matvju/#{0}'.format(anchor)
    title = 'Oracle materialized view and other development-related objects monitoring'
    return doc(url, title)


def overwrite_all_doc(_dict, link):
    l = doc_link(link)
    for k, v in _dict.items():
        v.update(l)
