import yasm_alert


def mds(mds_installation_type, namespace, **kwargs):
    warn_threshold = kwargs.get("warn_threshold", 80)
    crit_threshold = kwargs.get("crit_threshold", 90)
    checks = {
        "mds-unispace": {
            "yasm": {
                "signal": "perc(mastermind-namespaces.stats.effective_used_space_axxn,mastermind-namespaces.stats.space_limit_axxx)",
                "tags": yasm_alert.Tags(
                    itype=["mdscloud"],
                    ctype=[mds_installation_type],
                    prj=[namespace]
                ),
                "mgroups": ["CON"],
                "warn": [warn_threshold, crit_threshold],
                "crit": [crit_threshold, None]
            }
        }
    }
    return checks


def s3_mds(mds_installation_type, alias, service_id, warn_threshold=50, crit_threshold=60):
    checks = {
        "{}-used-space".format(alias): {
            "yasm": {
                "signal": "perc(s3mds_service_stat-service_used_space_max,s3mds_service_stat-service_max_size_max)",
                "tags": yasm_alert.Tags(
                    itype=["s3mdsstat"],
                    ctype=[mds_installation_type],
                    prj=[str(service_id)]
                ),
                "mgroups": ["CON"],
                "warn": [warn_threshold, crit_threshold],
                "crit": [crit_threshold, None]
            }
        }
    }
    return checks
