from paysys.sre.tools.monitorings.lib.util.helpers import unreach_skip, merge, ttl, flaps, check
from paysys.sre.tools.monitorings.lib.checks.doc import doc, doc_link
from paysys.sre.tools.monitorings.lib.util.aggregators import logic_and, downtime_skip

isc_dhcp = check('isc-dhcp-server')
haproxy = {'haproxy': merge(ttl(620, 60), doc_link('common'))}

keepalived = {
    'keepalived_conf': merge(
        ttl(1200, 300),
        flaps(300, 14400, 0),
        unreach_skip
    )
}

nginx_alive = {'nginx-alive': merge(ttl(600, 90), doc_link('common'))}
nginx_errors = {'nginx-errors': merge(flaps(900, 1500), ttl(600, 90), doc_link('common'))}
nginx = merge(nginx_alive, nginx_errors)

squid = check('squid-alive')

postfix = {
    'postfix': {},
    'postfix-queue': {}
}

ipsec = check('ipsec')

mysql = {
    'mysql-repl': {},
    'mysql-metrics': {}
}
mysqldump = {"mysqldump": ttl(7300, 3700)}

mysqldump_validate = check("mysqldump-validate", ttl(7300, 3700))

mysql_xtrabackup = check('mysql_xtrabackup', ttl(3600, 7200))

mysql_status = check('mysql_status')

memcached = check('memcached-alive')

named = check('named-alive')
mailq = check('mail_queue', merge(ttl(700, 300), doc_link('hyperion.paysys')))
splunk = check('splunkforwarder')
zookeeper = check('zookeeper')
ps_ping = check('ps-ping-alive')
ps_closedc = check('ps-closedc', merge(ttl(620, 60), flaps(180, 620)))

yandex_passport_tvmtool = check('yandex-passport-tvmtool')
pushclient_check = check(
    "pushclient_check",
    ttl(900, 300),
    flaps(900, 900),
)
gen_tns_check = check("gen_tns_check")

yandex_cauth_cache = check('yandex-cauth-cache', merge(ttl(900, 60), doc_link('oebs.paysys')))

jmx2graphite = {'jmx2graphite-config-generator': merge(flaps(900, 1500), ttl(700, 300), doc_link('common')),
                'jmx2graphite-process': merge(flaps(900, 1500), ttl(700, 300), doc_link('common'))}

oracle_rac = {'asm-status-ng': merge(ttl(700, 300), doc_link('common.oracle')),
              'bora-configs': merge(ttl(620, 300), doc_link('common.oracle')),
              'crs-autostart': merge(flaps(900, 1500), ttl(4200, 300), doc_link('common.oracle')),
              'iscsi-ips': merge(ttl(3800, 300), doc_link('common')),
              'iscsi-params': merge(ttl(3800, 300), doc_link('common')),
              'rdbms-audit-tmpfs': merge(ttl(1200, 60), doc_link('common.oracle')),
              'oracle-patches': merge(ttl(3000, 700), doc_link('common.oracle')),
              'oracleasm_iid_cnt': merge(ttl(700, 300), doc_link('common.oracle')),
              }

oracle_database = {'db-file_locations': merge(ttl(1800, 350), doc_link('common.oracle')),
                   'db-parameters': merge(ttl(620, 300), doc_link('common.oracle')),
                   'fk-indexing': merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip, doc_link('common.oracle')),
                   'hugepages': merge(ttl(900, 90), doc_link('common.oracle')),
                   'matview-monitor': merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip, doc_link('common.oracle')),
                   'matview-refresh': merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip, doc_link('common.oracle')),
                   'mvlogmove': merge(ttl(3700, 300), logic_and, doc_link('common.oracle')),
                   'net_services': merge(flaps(900, 0), ttl(4200, 300), doc_link('common.oracle')),
                   'oracle_memory_usage': merge(ttl(700, 300), doc_link('common.oracle')),
                   'oracle-status': merge(ttl(3700, 300), doc_link('common.oracle'), logic_and, unreach_skip, downtime_skip,),
                   'ps_segment_info': merge(flaps(900, 0), ttl(4200, 300), doc_link('common.oracle')),
                   'ps_ts_info': merge(flaps(900, 0), ttl(4200, 300), doc_link('common.oracle')),
                   'psdbstat': merge(flaps(900, 1500), ttl(300, 90), doc_link('common.oracle')),
                   'rm-logs': merge(ttl(3700, 300), doc_link('common.oracle')),
                   'rm-traces': merge(ttl(620, 300), doc_link('common.oracle')),
                   'ro-services': merge(ttl(700, 300), doc_link('common.oracle')),
                   'shared_pool_free_mem': merge(ttl(620, 300), logic_and, unreach_skip, downtime_skip, doc_link('common.oracle')),
                   'standby-lag': merge(ttl(1000, 300), doc_link('common.oracle')),
                   'user-objects-in-sys': merge(ttl(620, 300), logic_and, unreach_skip, downtime_skip, doc_link('common.oracle')),
                   }

ldap = {'ldap-limits': merge(ttl(620, 250), doc_link('oebs.paysys')),
        'ldaps': merge(ttl(620, 250), doc_link('oebs.paysys'))}

stunnel = check('stunnel', merge(ttl(700, 300), doc_link('oebs.paysys')))
sslcerts = check('ssl-certs', merge(ttl(900, 350), doc_link('wto.oebs.yandex-team.ru')))
pipeline_sender = check('pipeline-sender', merge(ttl(700, 300)), doc_link('common'))

audit = {'audit-splunk': merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip, doc_link('common.oracle')),
         'store_audit': merge(ttl(3700, 300), logic_and, unreach_skip, downtime_skip, doc_link('common.oracle'))}

check_slb = {'check_slb': merge(ttl(700, 300), doc_link('common'))}

locker_server = {'scheduler': merge(ttl(600, 300), doc_link('cloning.oebs.paysys')),
                 'locker-server': merge(ttl(600, 300), doc_link('cloning.oebs.paysys'))}  # TODO: rename

redis = check('redis', merge(ttl(600, 300), doc_link('pcrm.paysys')))

gluster_health = check('gluster_health', merge(ttl(700, 300), doc_link('oebs.paysys')))
solomon_agent = check("solomon-agent", doc("common"))
yandex_duckgo = check("yandex-duckgo")
sox_agent = check("sox-agent", ttl(150, 30))
