import logging
import traceback
from juggler_sdk import NotificationOptions
from paysys.sre.tools.monitorings.lib.util.helpers import merge

DEFAULT_TELEGRAM_GROUP = []
DEFAULT_TELEGRAM_DELAY = 120
DEFAULT_CALENDAR_ID = None
DEFAULT_ABC_DUTY = []
DEFAULT_IRON_WOMAN_DELAY = 60
DEFAULT_ESCALATION_USERS = []

BALANCE_ESCALATION_USERS = ['@svc_srevteam:oracle-dba-duty', '@svc_srevteam:oracle-dba-duty-backup', '@svc_srevteam:oracle-dba-duty-backup2']
FIN_TOOLS_ESCALATION_USERS = ['@svc_shorrty_team:oncall', '@svc_shorrty_team:reserve', 'shorrty']
BALANCE_DEV_ESCALATION_USERS = ['@svc_balance:balance_release']

OEBS_TRAIL = ['artkuznetsov', 'ngruzintsev', 'ygazaryan', 'askort']
BI_ESCALATION_USERS = ['@svc_bi_mstr:admin', '@svc_bi_mstr:admin2'] + OEBS_TRAIL
HYP_ESCALATION_USERS = ['@svc_hyperion:admin', '@svc_hyperion:admin2'] + OEBS_TRAIL
OEBS_ESCALATION_USERS = ['@svc_oebs:admin', '@svc_oebs:admin2'] + OEBS_TRAIL
UZEDO_ESCALATION_USERS = ['@svc_uzedo:admin', '@svc_uzedo:admin2'] + OEBS_TRAIL

FIN_TOOLS_TELEGRAM_GROUP = ['balance-dcs']
BALANCE_DEV_TELEGRAM_GROUP = ['Balance_Monitorings']
YB_LOG_TARIFF_MONITORINGS_GROUP = ['balance_log_tariff_monitorings']

YABANK_ESCALATION_USERS = ['smirnovvo', 'artkuznetsov', 'ngruzintsev', 'shchukin']


def status_change(
    from_,  # type: str
    to,  # type: str
):
    return {"from": from_, "to": to}


class Notifications:
    def __init__(self):
        self._noop_default_options = _noop_default_options.copy()
        self._telegram_default_options = _telegram_default_options.copy()
        self._telegram_critonly_options = _telegram_critonly_options.copy()
        self._sms_default_options = _sms_default_options.copy()
        self._sms_abc_default_options = _sms_abc_default_options.copy()
        self._golem_default_options = _golem_default_options.copy()
        self._golem_daytime_default_options = _golem_daytime_default_options.copy()
        self._golem_warn_only_default_options = _golem_warn_only_default_options.copy()
        self._sms_graphite_default_options = _sms_graphite_default_options.copy()
        self._sms_abc_graphite_default_options = _sms_abc_graphite_default_options.copy()
        self._telegram_graphite_default_options = _telegram_graphite_default_options.copy()
        self._telegram_daytime_options = _telegram_daytime_default_options.copy()
        self._startrek_default_options = {}
        self._iron_woman_default_options = _iron_woman_default_options.copy()
        self._iron_woman_daytime_default_options = _iron_woman_daytime_default_options.copy()
        self._render_all()

    def set_telegram(self, group, delay=DEFAULT_TELEGRAM_DELAY, statuses=None):
        _groups = group if isinstance(group, list) else [group]

        self._telegram_default_options['login'] = _groups
        self._telegram_critonly_options['login'] = _groups
        self._telegram_graphite_default_options['login'] = _groups
        self._telegram_daytime_options['login'] = _groups

        if delay is None:
            self._telegram_default_options.pop('delay', None)
            self._telegram_critonly_options.pop('delay', None)
            self._telegram_graphite_default_options.pop('delay', None)
            self._telegram_daytime_options.pop('delay', None)
        else:
            self._telegram_default_options['delay'] = delay
            self._telegram_critonly_options['delay'] = delay
            self._telegram_graphite_default_options['delay'] = delay
            self._telegram_daytime_options['delay'] = delay

        if statuses is not None:
            self._telegram_default_options['status'] = statuses
            self._telegram_critonly_options['status'] = statuses
            self._telegram_graphite_default_options['status'] = statuses
            self._telegram_daytime_options['status'] = statuses

        self._render_all()
        return self

    def set_calendar(self, calendar):
        self._sms_default_options["calendar_id"] = calendar
        self._sms_graphite_default_options["calendar_id"] = calendar
        self._render_all()
        return self

    def set_abc_duty(self, abc_duty):
        _abc_duty = abc_duty if isinstance(abc_duty, list) else [abc_duty]
        self._sms_abc_default_options["login"] = _abc_duty
        self._sms_abc_graphite_default_options["login"] = _abc_duty

        self._render_all()
        return self

    def set_startrek(
        self,
        queue,
        issue=None,
        status="CRIT",
        components=None,
        assignee=None,
        followers=None,
        delay=None,
        priority="normal",
        on_dashboard=True,
    ):
        if components is not None and issue is not None:
            raise Exception(
                "Cannot create startrek notification rule: "
                "should be specified only one field of [issue, components]"
            )

        self._startrek_default_options["queue"] = queue

        supported_statuses = ["CRIT", "WARN", "OK"]
        if status in supported_statuses:
            self._startrek_default_options["status"] = status
        else:
            raise Exception(
                "Status {} not in the list of supported: [{}]".format(
                    status,
                    supported_statuses,
                )
            )

        supported_priorities = ["blocker", "critical", "normal", "minor", "trivial"]
        if priority in supported_priorities:
            self._startrek_default_options["priority"] = priority
        else:
            raise Exception(
                "Priority {} not in the list of supported: [{}]".format(
                    priority,
                    supported_priorities,
                )
            )

        self._startrek_default_options["followers"] = \
            followers if followers is not None else []

        if assignee is not None:
            self._startrek_default_options["assignee"] = assignee

        if components is not None:
            self._startrek_default_options["components"] = components

        if issue is not None:
            self._startrek_default_options["issue"] = issue

        if delay is not None:
            if not isinstance(delay, int):
                raise TypeError("Delay must be of type int()")
            self._startrek_default_options["delay"] = delay

        self._startrek_default_options["on_dashboard"] = on_dashboard

        self._render_all()

        return self

    def set_iron_woman(self,
                       logins=None,
                       delay=None
                       ):
        if logins is None:
            logins = list(DEFAULT_ESCALATION_USERS)
        if delay is None:
            delay = DEFAULT_IRON_WOMAN_DELAY

        _logins = logins if isinstance(logins, list) else [logins]
        self._iron_woman_daytime_default_options["logins"] = _logins
        self._iron_woman_default_options["logins"] = _logins
        self._iron_woman_default_options["delay"] = delay
        self._iron_woman_daytime_default_options["delay"] = delay
        self._render_all()
        return self

    @staticmethod
    def notifications(args):
        return {'notifications': args}

    def _render_all(self):
        _noop = [
            NotificationOptions(
                'on_status_change',
                self._noop_default_options.copy(),
                "https://wiki.yandex-team.ru/DljaAdminov/paysys/Monitoring/#faq",
            )
        ]

        _golem = [NotificationOptions('golem', self._golem_default_options.copy())]
        _golem_daytime = [NotificationOptions('golem', self._golem_daytime_default_options.copy())]
        _golem_warn_only = [NotificationOptions('golem', self._golem_warn_only_default_options.copy())]

        _sms = [NotificationOptions('on_status_change', self._sms_default_options.copy())]
        _sms_abc = [NotificationOptions('on_status_change', self._sms_abc_default_options.copy())]
        _sms_graphite = [NotificationOptions('on_status_change', self._sms_graphite_default_options.copy())]
        _sms_abc_graphite = [NotificationOptions('on_status_change', self._sms_abc_graphite_default_options.copy())]

        _telegram = [NotificationOptions('on_status_change', self._telegram_default_options.copy())]
        _telegram_critonly = [NotificationOptions('on_status_change', self._telegram_critonly_options.copy())]
        _telegram_graphite = [NotificationOptions('on_status_change', self._telegram_graphite_default_options.copy())]
        _telegram_daytime = [NotificationOptions('on_status_change', self._telegram_daytime_options.copy())]

        _startrek = [
            NotificationOptions(
                'startrek',
                self._startrek_default_options.copy(),
            ),
        ]

        _iron_woman = [
            NotificationOptions(
                'phone_escalation',
                self._iron_woman_default_options.copy()
            )
        ]
        _iron_woman_daytime = [
            NotificationOptions(
                'phone_escalation',
                self._iron_woman_daytime_default_options.copy()
            )
        ]

        _startrek_and_telegram = _startrek + _telegram
        _startrek_and_telegram_critonly = _startrek + _telegram_critonly

        _sms_and_telegram = _sms + _telegram
        _sms_abc_and_telegram = _sms_abc + _telegram

        _golem_and_sms = _golem + _sms
        _golem_and_sms_abc = _golem + _sms_abc
        _golem_and_sms_graphite = _golem + _sms_graphite
        _golem_and_sms_abc_graphite = _golem + _sms_abc_graphite
        _golem_and_sms_and_telegram = _golem + _sms + _telegram
        _golem_and_sms_abc_and_telegram = _golem + _sms_abc + _telegram
        _golem_and_sms_and_telegram_graphite = _golem + _sms_graphite + _telegram_graphite
        _golem_and_sms_abc_and_telegram_graphite = _golem + _sms_abc_graphite + _telegram_graphite

        _iron_woman_and_sms = _iron_woman + _sms
        _iron_woman_and_sms_abc = _iron_woman + _sms_abc
        _iron_woman_and_sms_graphite = _iron_woman + _sms_graphite
        _iron_woman_and_sms_abc_graphite = _iron_woman + _sms_abc_graphite
        _iron_woman_and_sms_and_telegram = _iron_woman + _sms + _telegram
        _iron_woman_and_sms_abc_and_telegram = _iron_woman + _sms_abc + _telegram
        _iron_woman_and_sms_and_telegram_critonly = _iron_woman + _sms + _telegram_critonly
        _iron_woman_and_sms_abc_and_telegram_critonly = _iron_woman + _sms_abc + _telegram_critonly
        _iron_woman_and_sms_and_telegram_graphite = _iron_woman + _sms_graphite + _telegram_graphite
        _iron_woman_and_sms_abc_and_telegram_graphite = _iron_woman + _sms_abc_graphite + _telegram_graphite
        _iron_woman_daytime_and_sms = _iron_woman_daytime + _sms
        _iron_woman_daytime_and_sms_abc = _iron_woman_daytime + _sms_abc
        _iron_woman_and_telegram = _iron_woman + _telegram
        _iron_woman_and_telegram_graphite = _iron_woman + _telegram_graphite
        _iron_woman_and_telegram_critonly = _iron_woman + _telegram_critonly
        _iron_woman_and_startrek_and_telegram = _iron_woman + _startrek + _telegram
        _iron_woman_and_startrek_and_telegram_critonly = _iron_woman + _startrek + _telegram_critonly
        _iron_woman_daytime_and_telegram = _iron_woman_daytime + _telegram
        _iron_woman_daytime_and_telegram_critonly = _iron_woman_daytime + _telegram_critonly
        _iron_woman_daytime_and_sms_and_telegram = _iron_woman_daytime_and_sms + _telegram
        _iron_woman_daytime_and_sms_abc_and_telegram = _iron_woman_daytime_and_sms_abc + _telegram
        _iron_woman_daytime_and_startrek_critonly = _iron_woman_daytime + _startrek
        _iron_woman_daytime_and_startrek_and_telegram_critonly = _iron_woman_daytime + _startrek + _telegram_critonly

        self.telegram_graphite = self.notifications(_telegram_graphite)

        self.noop = self.notifications(_noop)

        self.golem = self.notifications(_golem)
        self.golem_daytime = self.notifications(_golem_daytime)
        self.golem_warn_only = self.notifications(_golem_warn_only)
        self.golem_and_sms = self.notifications(_golem_and_sms)
        self.golem_and_sms_abc = self.notifications(_golem_and_sms_abc)
        self.golem_and_sms_graphite = self.notifications(_golem_and_sms_graphite)
        self.golem_and_sms_abc_graphite = self.notifications(_golem_and_sms_abc_graphite)
        self.golem_and_sms_and_telegram = self.notifications(_golem_and_sms_and_telegram)
        self.golem_and_sms_abc_and_telegram = self.notifications(_golem_and_sms_abc_and_telegram)
        self.golem_and_sms_and_telegram_graphite = self.notifications(_golem_and_sms_and_telegram_graphite)
        self.golem_and_sms_abc_and_telegram_graphite = self.notifications(_golem_and_sms_abc_and_telegram_graphite)

        self.sms = self.notifications(_sms)
        self.sms_abc = self.notifications(_sms_abc)
        self.telegram = self.notifications(_telegram)
        self.telegram_critonly = self.notifications(_telegram_critonly)
        self.telegram_daytime = self.notifications(_telegram_daytime)
        self.sms_and_telegram = self.notifications(_sms_and_telegram)
        self.sms_abc_and_telegram = self.notifications(_sms_abc_and_telegram)

        self.startrek = self.notifications(_startrek)
        self.startrek_and_telegram = self.notifications(_startrek_and_telegram)
        self.startrek_and_telegram_critonly = self.notifications(_startrek_and_telegram_critonly)

        self.iron_woman = self.notifications(_iron_woman)
        self.iron_woman_daytime = self.notifications(_iron_woman_daytime)
        self.iron_woman_and_sms = self.notifications(_iron_woman_and_sms)
        self.iron_woman_and_sms_abc = self.notifications(_iron_woman_and_sms_abc)
        self.iron_woman_and_sms_graphite = self.notifications(_iron_woman_and_sms_graphite)
        self.iron_woman_and_sms_abc_graphite = self.notifications(_iron_woman_and_sms_abc_graphite)
        self.iron_woman_and_sms_and_telegram = self.notifications(_iron_woman_and_sms_and_telegram)
        self.iron_woman_and_sms_abc_and_telegram = self.notifications(_iron_woman_and_sms_abc_and_telegram)
        self.iron_woman_and_sms_and_telegram_graphite = self.notifications(_iron_woman_and_sms_and_telegram_graphite)
        self.iron_woman_and_sms_abc_and_telegram_graphite = self.notifications(_iron_woman_and_sms_abc_and_telegram_graphite)
        self.iron_woman_daytime_and_sms = self.notifications(_iron_woman_daytime_and_sms)
        self.iron_woman_daytime_and_sms_abc = self.notifications(_iron_woman_daytime_and_sms_abc)
        self.iron_woman_and_sms_and_telegram_critonly = self.notifications(_iron_woman_and_sms_and_telegram_critonly)
        self.iron_woman_and_sms_abc_and_telegram_critonly = self.notifications(_iron_woman_and_sms_abc_and_telegram_critonly)
        self.iron_woman_and_telegram = self.notifications(_iron_woman_and_telegram)
        self.iron_woman_and_telegram_critonly = self.notifications(_iron_woman_and_telegram_critonly)
        self.iron_woman_daytime_and_telegram = self.notifications(_iron_woman_daytime_and_telegram)
        self.iron_woman_daytime_and_telegram_critonly = self.notifications(_iron_woman_daytime_and_telegram_critonly)
        self.iron_woman_daytime_and_sms_and_telegram = self.notifications(_iron_woman_daytime_and_sms_and_telegram)
        self.iron_woman_daytime_and_sms_abc_and_telegram = self.notifications(_iron_woman_daytime_and_sms_abc_and_telegram)
        self.iron_woman_daytime_and_startrek_critonly = self.notifications(_iron_woman_daytime_and_startrek_critonly)
        self.iron_woman_and_startrek_and_telegram = self.notifications(_iron_woman_and_startrek_and_telegram)
        self.iron_woman_and_startrek_and_telegram_critonly = self.notifications(_iron_woman_and_startrek_and_telegram_critonly)
        self.iron_woman_and_telegram = self.notifications(_iron_woman_and_telegram)
        self.iron_woman_and_telegram_graphite = self.notifications(_iron_woman_and_telegram_graphite)
        self.iron_woman_daytime_and_startrek_and_telegram_critonly = self.notifications(_iron_woman_daytime_and_startrek_and_telegram_critonly)


# Golem notifications
_golem_default_options = {}

_golem = [
    NotificationOptions('golem', _golem_default_options)
]

_golem_daytime_default_options = dict(_golem_default_options)
_golem_daytime_default_options["time_start"] = "10:00"
_golem_daytime_default_options["time_end"] = "20:00"

_golem_daytime = [
    NotificationOptions('golem', _golem_daytime_default_options)
]

# This notification type (noop) should be used for a nonprod checks.
# We just need a way to distinguish unused nonprod checks from the important ones.
# So we create an empty notifications to have an ability to filter out the checks
# with notifications on a juggler dashboard.
# Example: https://juggler.yandex-team.ru/dashboards/paysys/
# Doc: https://wiki.yandex-team.ru/DljaAdminov/paysys/Monitoring/#faq
_noop_default_options = dict(_golem_default_options)
_noop_default_options["time_start"] = "10:00"
_noop_default_options["time_end"] = "10:01"
_noop_default_options["description_globs"] = "never_send_notifications_for_this_event"
_noop_default_options["min_interval"] = 86399
_noop_default_options["login"] = "robot-test-paysys"

_noop = [
    NotificationOptions(
        "on_status_change",
        _noop_default_options,
        "https://wiki.yandex-team.ru/DljaAdminov/paysys/Monitoring/#faq",
    )
]

_golem_warn_only_default_options = dict(_golem_default_options)
_golem_warn_only_default_options["time_start"] = "10:00"
_golem_warn_only_default_options["time_end"] = "10:01"

_golem_warn_only = [
    NotificationOptions('golem', _golem_warn_only_default_options)
]

# SMS notifications
_sms_default_options = {
    "method": ["sms"],
    "status": ["CRIT", "OK"],
    "delay": 120,
    "calendar_id": DEFAULT_CALENDAR_ID
}

_sms_abc_default_options = {
    "method": ["sms"],
    "status": ["CRIT", "OK"],
    "delay": 120,
    "login": DEFAULT_ABC_DUTY
}

_sms = [NotificationOptions('on_status_change', _sms_default_options)]

_sms_graphite_default_options = dict(_sms_default_options)
_sms_graphite_default_options["description_globs"] = "metric*"

_sms_graphite = [
    NotificationOptions('on_status_change', _sms_graphite_default_options)
]

_sms_abc_graphite_default_options = dict(_sms_abc_default_options)
_sms_abc_graphite_default_options["description_globs"] = "metric*"

_sms_abc_graphite = [
    NotificationOptions('on_status_change', _sms_abc_graphite_default_options)
]

# Telegram notifications
_telegram_default_options = {
    "method": ["telegram"],
    "status": ["CRIT", "OK"],
    "delay": DEFAULT_TELEGRAM_DELAY,
    "login": DEFAULT_TELEGRAM_GROUP,
}

_telegram_critonly_options = _telegram_default_options.copy()

_telegram_critonly_options["status"] = ["CRIT"]

_telegram_graphite_default_options = dict(_telegram_default_options)

_telegram_graphite_default_options["description_globs"] = "metric*"

_telegram_daytime_default_options = _telegram_default_options.copy()
_telegram_daytime_default_options["time_start"] = "10:00"
_telegram_daytime_default_options["time_end"] = "20:00"

_telegram = [NotificationOptions('on_status_change', _telegram_default_options)]

_telegram_critonly = [NotificationOptions('on_status_change', _telegram_critonly_options)]

_telegram_graphite = [
    NotificationOptions('on_status_change', _telegram_graphite_default_options)
]


def deprecation_warning():
    logging.error("NOTIFICATIONS: Deprecated api, use lib.notifications.Notifications api")
    traceback.print_stack()


def telegram_graphite_templ(group="yndx-mnt-fin-payment_monitoring"):
    deprecation_warning()
    telegram_graphite_options = dict(_telegram_graphite_default_options)
    telegram_graphite_options["login"] = [group]
    return Notifications.notifications([NotificationOptions(
        'on_status_change',
        telegram_graphite_options,
    )])


_golem_and_sms = _golem + _sms

_golem_and_sms_graphite = _golem + _sms_graphite

_golem_and_sms_and_telegram = _golem + _sms + _telegram

_golem_and_sms_and_telegram_graphite = _golem + _sms_graphite + _telegram_graphite


def notifications(args):
    deprecation_warning()
    return {'notifications': args}


def calid(cal_id):
    deprecation_warning()
    return merge(_sms_default_options, {'calendar_id': cal_id})


_iron_woman_default_options = {
    'delay': DEFAULT_IRON_WOMAN_DELAY,
    'logins': DEFAULT_ESCALATION_USERS
}

_iron_woman = [
    NotificationOptions("phone_escalation", _iron_woman_default_options)
]

_iron_woman_daytime_default_options = _iron_woman_default_options.copy()
_iron_woman_daytime_default_options["time_start"] = "10:00"
_iron_woman_daytime_default_options["time_end"] = "20:00"

_iron_woman_daytime = [
    NotificationOptions(
        'phone_escalation',
        _iron_woman_daytime_default_options
    )
]

noop = Notifications.notifications(_noop)
golem = Notifications.notifications(_golem)
golem_daytime = Notifications.notifications(_golem_daytime)
golem_warn_only = Notifications.notifications(_golem_warn_only)
golem_and_sms = Notifications.notifications(_golem_and_sms)
golem_and_sms_graphite = Notifications.notifications(_golem_and_sms_graphite)
golem_and_sms_and_telegram = Notifications.notifications(_golem_and_sms_and_telegram)
golem_and_sms_and_telegram_graphite = Notifications.notifications(_golem_and_sms_and_telegram_graphite)
