import requests

from paysys.sre.tools.monitorings.lib.util.helpers import get_yc_token


class YandexCloudClient(object):
    HOST = "gw.db.yandex-team.ru"

    def __init__(self, token):
        self.iam_token = self.create_iam_token(token)

    def create_iam_token(self, token):
        url = "https://{}/iam/v1/tokens".format(self.HOST)
        resp = requests.post(url, json={"yandexPassportOauthToken": token})
        resp.raise_for_status()
        return resp.json()["iamToken"]

    def list_mongodb_cluster_hosts(self, cluster_id):
        url = "https://{}/managed-mongodb/v1/clusters/{}/hosts".format(
            self.HOST, cluster_id
        )
        return self.get_json(url)

    def list_mongodb_cluster_shards(self, cluster_id):
        url = "https://{}/managed-mongodb/v1/clusters/{}/shards".format(
            self.HOST, cluster_id
        )
        return self.get_json(url)

    def get_json(self, url):
        headers = {
            "Content-Type": "application/json",
            "Authorization": "Bearer {}".format(self.iam_token),
        }
        resp = requests.get(url, headers=headers)
        resp.raise_for_status()
        return resp.json()


_default_client = None


def get_default_client(cached=True):
    global _default_client
    if _default_client is None or not cached:
        _default_client = YandexCloudClient(token=get_yc_token())
    return _default_client
