import json

from scripts.solomon_conversion_dashboard import processings

graphs = [
    "terminal_authorization_time",
]
graphs_names = [
    "Terminal authorization time for %s",
]

if __name__ == '__main__':
    dashbord_json = open("dashboards/authorization_time.json", "r")
    try:
        data = json.loads(dashbord_json.read())
        rows = list()
        row = dict()
        panels = list()
        for processing_idx, processing in enumerate(processings):
            for graph_idx, graph in enumerate(graphs):
                panel = dict()
                panel["type"] = "IFRAME"
                panel["title"] = graphs_names[graph_idx] % (processing)
                panel["url"] = "/?project=trust&cluster=greed-prod" \
                               "&graph=%s&service_id={{service_id}}&processing_cc=%s" % (graph, processing)
                panel["rowspan"] = 0
                panel["colspan"] = 0
                panels.append(panel)
            if len(panels) % 4 == 0 or processing_idx == len(processings) - 1:
                row["panels"] = panels
                rows.append(row)
                panels = list()
                row = dict()
        data['rows'] = rows
        print(json.dumps(data))
    finally:
        dashbord_json.close()
